/*****************************************************************************
 
            Copyright (c)2005 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/
 
/* $Id: read_polygon.c 11506 2008-01-08 19:16:38Z foucher $ */
 
#include <GTXClient.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define GTX_STUDY    "GTXserver_Tests"
#define GTX_DIR      "read"
#define GTX_FILE     "polygons"

#define DEFAULT_GTX_SERVERNAME "localhost"

#define MAX_HOSTNAME_LEN 1024
#define MAX_PATH_LEN     1024

char *GTXvar_types[] =
{
  "Float",
  "Character",
  "X gravity center",
  "Y gravity center",
  "Z gravity center",
  "Macro"
};

/*****************************************************************************
**
** FUNCTION:    st_usage
**
** DESCRIPTION: gives this program usage
**
** RETURNS:     Nothing
**
** ARGUMENTS:   int help : 1 to obtain a complete help
**
*****************************************************************************/
static void st_usage(char *exe_name,
                     int help)
{
  (void)printf("Usage: %s [-help] [-host hostname] [-port port_number]\n",
               exe_name);
  (void)printf("          [-path data_path]");

  if (help)
  {
    (void)printf(" -help             : Print this message.\n");
    (void)printf(" -debug            : Print client/server messages.\n");
    (void)printf(" -host hostname    : Server's hostname.\n");
    (void)printf(" -port port_number : Port used between client and server\n");
    (void)printf(" -path data_path   : Initialize connection with given data_path.\n");
    (void)printf("The default is to run a new server on a random port.");
    (void)printf("If -host or -port is specified, a server must have been started first on the given host/port");
  }
}

/****************************************************************************
**
** FUNCTION:    main
**
** DESCRIPTION: client's main function
**
** RETURNS:     Nothing
**
** ARGUMENTS:   int argv, char *argv : program arguments
**
*****************************************************************************/
int main(int argc,
         char *argv[])
{
  char *tmp_str, host[MAX_HOSTNAME_LEN];
  unsigned short port;
  int i,j,error,run_server;
  char data_path[MAX_PATH_LEN];

  GTXPolygonSystem psystem;
  
  char **studies = NULL;
  char **dirs = NULL;
  char **files = NULL;
  char **vars = NULL;
  int  *indices = NULL;

  error = 1;
  run_server = 1;
  psystem.polygons = NULL;
  port = GTXClientGetDefaultPort();

  (void)strcpy(host, DEFAULT_GTX_SERVERNAME);
  (void)strcpy(data_path, "");

  for (i=1; i<argc; i++)
  {
    if (!strcmp(argv[i], "-port"))
    {
      i++;
      if (i<argc)
      {
        run_server = 0;
        port = (unsigned short)strtol(argv[i], &tmp_str, 10);
        if (port == 0 && tmp_str == argv[i])
        {
          (void)fprintf(stderr,"Invalid Port Number.");
          exit(1);
        }
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-host"))
    {
      i++;
      if (i<argc)
      {
        run_server = 0;
        if (strlen(argv[i]) > MAX_HOSTNAME_LEN-1)
        {
          (void)fprintf(stderr,"Host Name must contain less than %d characters.",
                        MAX_HOSTNAME_LEN);
          exit(1);
        }
        (void)strcpy(host, argv[i]);
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-path"))
    {
      i++;
      if (i<argc)
      {
        if (strlen(argv[i]) > MAX_PATH_LEN-1)
        {
          (void)fprintf(stderr,"Path must contain less than %d characters.",
                       MAX_PATH_LEN);
          exit(1);
        }
        (void)strcpy(data_path, argv[i]);
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-debug"))
      GTXClientDebug(1);
    else if (!strcmp(argv[i], "-help"))
    {
      st_usage(argv[0], 1);
      exit(0);
    }
  }

  /*
  ** Connect to the server
  */
  if (GTXClientInitialize(GTX_CLIENT_VERSION))
    goto label_end;
  if (run_server)
  {
    port = 0;
    if (GTXClientRunGTXserver(&port))
      goto label_end;
  }
  if (GTXClientConnect(host, port, data_path))
    goto label_end;

  /*
  ** Set current study
  */
  if (GTXClientSetStudy(GTX_STUDY))
    goto label_end;

  /*
  ** Set current study
  */
  if (GTXClientSetDirectory(GTX_DIR))
    goto label_end;

  /*
  ** Set current file
  */
  if (GTXClientSetFile(GTX_FILE))
    goto label_end;
 
  /*
  ** Read polygon from current file
  */
  if (GTXClientReadPolygons(&psystem))
     goto label_end;

  /*
  ** Display polygon structure
  */
  printf("Dump of polygons:\n");
  printf("Polygons dimension is %s\n", psystem.polygons_2d ? "2D" : "3D");
  printf("Polygon system extension in X: min=%f, max=%f\n", psystem.ext_min[0], psystem.ext_max[0]);
  printf("Polygon system extension in Y: min=%f, max=%f\n", psystem.ext_min[1], psystem.ext_max[1]);
  if (!psystem.polygons_2d)
    printf("Polygon system extension in Z: min=%f, max=%f\n", psystem.ext_min[2], psystem.ext_max[2]);
  printf("Number of polygons in polygon system: %"GTXLONG_FORMAT"\n", psystem.n_polygons);
  for (i=0; i<psystem.n_polygons; i++)
  {
    printf("\n  Polygon \"%s\"", psystem.polygons[i].name);
    if (strcmp(psystem.polygons[i].group_name, ""))
      printf(" which belongs to the group \"%s\"\n", psystem.polygons[i].group_name);
    else
      printf("\n");
    printf("  Thickness: min=%g, max=%g\n", psystem.polygons[i].z_min, psystem.polygons[i].z_max);
    printf("  Number of vertices: %d\n", psystem.polygons[i].n_vertices); 
    for (j=0; j<psystem.polygons[i].n_vertices; j++)
      printf("    Vertex %03d: %g, %g\n", j,
             psystem.polygons[i].vertices[(j*2+0)], psystem.polygons[i].vertices[(j*2+1)]);
  }

  error = 0;

label_end:
  GTXClientFreePolygons(&psystem);

  /*
  ** Disconnect from the server
  */
  GTXClientDisconnect();

  return(error);
}
