/*****************************************************************************
 
            Copyright (c)2008 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/
 
/* $Id: text_list.c 12705 2008-07-02 15:14:34Z martin $ */
 
#include <GTXClient.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define DEFAULT_GTX_SERVERNAME "localhost"

#define MAX_HOSTNAME_LEN 1024
#define MAX_PATH_LEN     1024

char *GTXfile_types[] =
{
  "Points",
  "Lines",
  "Grid"
};

char *GTXvar_types[] =
{
  "Float",
  "Character",
  "X gravity center",
  "Y gravity center",
  "Z gravity center",
  "Macro"
};

/*****************************************************************************
**
** FUNCTION:    st_usage
**
** DESCRIPTION: gives this program usage
**
** RETURNS:     Nothing
**
** ARGUMENTS:   int help : 1 to obtain a complete help
**
*****************************************************************************/
static void st_usage(char *exe_name,
                     int help)
{
  (void)printf("Usage: %s [-help] [-host hostname] [-port port_number]\n",
               exe_name);
  (void)printf("          [-path data_path]");

  if (help)
  {
    (void)printf(" -help             : Print this message.\n");
    (void)printf(" -debug            : Print client/server messages.\n");
    (void)printf(" -host hostname    : Server's hostname.\n");
    (void)printf(" -port port_number : Port used between client and server\n");
    (void)printf(" -path data_path   : Initialize connection with given data_path.\n");
    (void)printf("The default is to run a new server on a random port.");
    (void)printf("If -host or -port is specified, a server must have been started first on the given host/port");
  }
}

/****************************************************************************
**
** FUNCTION:    main
**
** DESCRIPTION: client's main function
**
** RETURNS:     Nothing
**
** ARGUMENTS:   int argv, char *argv : program arguments
**
*****************************************************************************/
int main(int argc,
         char *argv[])
{
  char *comment;
  char *tmp_str, host[MAX_HOSTNAME_LEN];
  unsigned short port;
  int istud,jdir,kfile,lvar;
  int i,j,error,run_server;
  char data_path[MAX_PATH_LEN];
  GTXFileInfo file_info;
  GTXVariableInfo var_info;
  GTXFaultInfo *fault_info;
  GTXFaultSystem fault_system;

  int nb_study;
  int nb_dir;
  int nb_file;
  int nb_var;
  int nb_indices;

  char **studies = NULL;
  char **dirs = NULL;
  char **files = NULL;
  char **vars = NULL;
  int  *indices = NULL;
  char **alpha_indices = NULL;

  error = 1;
  run_server = 1;
  if (GTXClientInitialize(GTX_CLIENT_VERSION))
    goto label_end;
  port = GTXClientGetDefaultPort();

  (void)strcpy(host, DEFAULT_GTX_SERVERNAME);
  (void)strcpy(data_path, "");

  for (i=1; i<argc; i++)
  {
    if (!strcmp(argv[i], "-port"))
    {
      i++;
      if (i<argc)
      {
        run_server = 0;
        port = (unsigned short)strtol(argv[i], &tmp_str, 10);
        if (port == 0 && tmp_str == argv[i])
        {
          (void)fprintf(stderr,"Invalid Port Number.");
          exit(1);
        }
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-host"))
    {
      i++;
      if (i<argc)
      {
        run_server = 0;
        if (strlen(argv[i]) > MAX_HOSTNAME_LEN-1)
        {
          (void)fprintf(stderr,"Host Name must contain less than %d characters.",
                        MAX_HOSTNAME_LEN);
          exit(1);
        }
        (void)strcpy(host, argv[i]);
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-path"))
    {
      i++;
      if (i<argc)
      {
        if (strlen(argv[i]) > MAX_PATH_LEN-1)
        {
          (void)fprintf(stderr,"Path must contain less than %d characters.",
                        MAX_PATH_LEN);
          exit(1);
        }
        (void)strcpy(data_path, argv[i]);
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-debug"))
      GTXClientDebug(1);
    else if (!strcmp(argv[i], "-help"))
    {
      st_usage(argv[0], 1);
      exit(0);
    }
  }

  /*
  ** Connect to the server
  */
  if (run_server)
  {
    port = 0;
    if (GTXClientRunGTXserver(&port))
      goto label_end;
  }
  if (GTXClientConnect(host, port, data_path))
    goto label_end;

  /*
  ** Get study list
  */
  if (GTXClientGetStudyList(&nb_study, &studies))
    goto label_end;

  for (istud=0; istud<nb_study; istud++)
  {
    (void)printf("Study: %s\n", studies[istud]);

    /*
    ** Set current study
    */
    if (GTXClientSetStudy(studies[istud]))
      goto label_end;

    /*
    ** Get directory list
    */
    if (GTXClientGetDirectoryList(&nb_dir, &dirs))
      goto label_end;

    for (jdir=0; jdir<nb_dir; jdir++)
    {
      (void)printf("\n  Directory: %s\n", dirs[jdir]);

      /*
      ** Set current directory
      */
      if (GTXClientSetDirectory(dirs[jdir]))
        goto label_end;

      /*
      ** Get file list
      */
      if (GTXClientGetFileList(&nb_file, &files))
        goto label_end;

      for (kfile=0; kfile<nb_file; kfile++)
      {
        (void)printf("\n    File: %s\n", files[kfile]);

        /*
        ** Set current file
        */
        if (GTXClientSetFile(files[kfile]))
          goto label_end;

        /*
        ** Get file info
        */
        if (GTXClientGetFileInfo(&file_info)) goto label_end;

        (void)printf("      Type: %s\n", GTXfile_types[file_info.type]);
        if (file_info.linked_file[0] != '\0')
          (void)printf("      Linked File: %s\n", file_info.linked_file);
        (void)printf("      Dimension: %dD\n",file_info.dimension);
        (void)printf("      Number of Samples: %"GTXLONG_FORMAT"\n",file_info.s_number);

        if (file_info.type == GTX_FILE_TYPE_GRAVITY_LINES)
          (void)printf("      Number of Lines: %d\n",file_info.item_number);
        else if (file_info.type == GTX_FILE_TYPE_GRID)
        {
          if (file_info.dimension == 2)
          {
            (void)printf("      Number of Nodes: (%d,%d)\n",
                         file_info.NX,file_info.NY);
            (void)printf("      Origin         : (%g,%g)\n",
                         file_info.X0,file_info.Y0);
            (void)printf("      Mesh Dimensions: (%g,%g)\n",
                         file_info.DX,file_info.DY);
            if (file_info.rotation)
              (void)printf("      Rotation Angle: %g\n", file_info.angle_z);
            else
              (void)printf("      No Rotation\n");
          }
          if (file_info.dimension == 3)
          {
            (void)printf("      Number of Nodes: (%d,%d,%d)\n",
                         file_info.NX,file_info.NY,file_info.NZ);
            (void)printf("      Origin         : (%g,%g,%g)\n",
                         file_info.X0,file_info.Y0,file_info.Z0);
            (void)printf("      Mesh Dimensions: (%g,%g,%g)\n",
                         file_info.DX,file_info.DY,file_info.DZ);
            if (file_info.rotation)
            {
              (void)printf("      Rotation Angle around Z: %g\n",
                           file_info.angle_z);
              (void)printf("      Rotation Angle around Y: %g\n",
                           file_info.angle_y);
              (void)printf("      Rotation Angle around X: %g\n",
                           file_info.angle_x);
            }
            else
              (void)printf("      No Rotation\n");
          } /* end of 3D grid */
        } /* end of  grid type */

        /* special variables information */
        (void)printf("      Sample Number variable   : %s\n",
                     file_info.sn_var_name);
        if (file_info.type == GTX_FILE_TYPE_GRAVITY_LINES)
        {
          (void)printf("      Line Number variable     : %s\n",
                       file_info.ln_var_name);
          (void)printf("      Relative Number variable : %s\n",
                       file_info.rn_var_name);
        }
        (void)printf("      X Gravity Center variable: %s\n",
                     file_info.xg_var_name);
        (void)printf("      Y Gravity Center variable: %s\n",
                     file_info.yg_var_name);
        if (file_info.dimension == 3)
          (void)printf("      Z Gravity Center variable: %s\n",
                       file_info.zg_var_name);

        /* faults information */
        if (file_info.faulted)
        {
          fault_info = &file_info.fault_info;
          (void)printf("\n      Faulted File:\n");
          (void)printf("      2D Faults              : %c\n",
                        (fault_info->faults_2d)? 'Y': 'N');
          (void)printf("      Auxiliary Variable Used: %c\n",
                        (fault_info->aux_var_used)? 'Y': 'N');
          (void)printf("      Number of faults       : %d\n",
                        fault_info->faults_number);
          (void)printf("      Number of segments     : %d\n",
                        fault_info->segments_number);
          (void)printf("      Minimum Used Priority  : %d\n",
                        fault_info->min_fpriority);
          (void)printf("      Maximum Used Priority  : %d\n",
                        fault_info->max_fpriority);
          (void)printf("      Authorized Priority    : %d\n",
                        fault_info->auth_priority);

          /* faults reading example */
          if (GTXClientReadFaults(0,&fault_system))
            goto label_end;
          (void)printf("\n      Dump of Faults:\n");
          for (i=0; i<fault_system.n_faults; i++)
          {
            (void)printf("        Fault \"%s\":\n", fault_system.faults[i].name);
            (void)printf("          %sPolygonal fault\n", fault_system.faults[i].polygon ? "" : "Not a ");
            (void)printf("          Number of segments: %d\n", fault_system.faults[i].n_segments);
            for (j=0; j<fault_system.faults[i].n_segments; j++)
            {
              (void)printf("          Segment %d\n", j+1);
              (void)printf("            Priority %d\n", fault_system.faults[i].segments[j].priority);
              (void)printf("            X1 = %g\n", fault_system.faults[i].segments[j].X1);
              (void)printf("            Y1 = %g\n", fault_system.faults[i].segments[j].Y1);
              if (!fault_system.faults_2d)
                (void)printf("            Z1 = %g\n", fault_system.faults[i].segments[j].Z1);
              (void)printf("            X2 = %g\n", fault_system.faults[i].segments[j].X2);
              (void)printf("            Y2 = %g\n", fault_system.faults[i].segments[j].Y2);
              if (!fault_system.faults_2d)
              {
                (void)printf("            Z2 = %g\n", fault_system.faults[i].segments[j].Z2);
                (void)printf("            X3 = %g\n", fault_system.faults[i].segments[j].X3);
                (void)printf("            Y3 = %g\n", fault_system.faults[i].segments[j].Y3);
                (void)printf("            Z3 = %g\n", fault_system.faults[i].segments[j].Z3);
              }
              if (fault_system.aux_var_used)
              {
                (void)printf("            V1 = %g\n", fault_system.faults[i].segments[j].V1);
                (void)printf("            V2 = %g\n", fault_system.faults[i].segments[j].V2);
                (void)printf("            V3 = %g\n", fault_system.faults[i].segments[j].V3);
              }
            }
          }
          GTXClientFreeFaults(&fault_system);
        } /* faults information */

        /*
        ** Get variable list
        */
        if (GTXClientGetVariableList(&nb_var, &vars))
          goto label_end;

        for (lvar=0; lvar<nb_var; lvar++)
        {
          (void)printf("\n      Variable: %s\n", vars[lvar]);

          /*
          ** Set current variable
          */
          if (GTXClientSetVariable(vars[lvar]))
            goto label_end;

          /*
          ** Get variable info
          */
          if (GTXClientGetVariableInfo(&var_info)) goto label_end;

          (void)printf("        Type: %s\n", GTXvar_types[var_info.type]);
          if (var_info.type == GTX_VAR_TYPE_CHAR)
            (void)printf("        Alpha Length: %d\n", var_info.alpha_length);
          else
          {
            if (var_info.bit_length == 1)
              (void)printf("        Precision: 1 bit (selection)\n");
            else
              (void)printf("        Precision: %d bits\n",var_info.bit_length);
            if (!var_info.implicit)
              (void)printf("        Unit: %s\n", var_info.unit);
          }

          if (GTXClientGetVariableComment(&comment)) goto label_end;
          if (comment[0] != '\0')
            (void)printf("        Comment: %s\n", comment);
          comment = GTXClientFreePointer(comment);
          if (var_info.type == GTX_VAR_TYPE_MACRO)
          {
            if (GTXClientGetMacroIndicesWithAlpha(&nb_indices, &indices,
                                                  &alpha_indices))
              goto label_end;
            (void)printf("          Number of Indices: %d\n", nb_indices);
            if (nb_indices == 0) continue;
            if (alpha_indices)
            {
              (void)printf("          Index -> Alpha Index:\n");
              for (i=0, j=0; i<nb_indices; i++)
                (void)printf("%06d -> %s\n", indices[i], alpha_indices[i]);
            }
            else
            {
              (void)printf("          Indices:\n");
              for (i=0, j=0; i<nb_indices; i++)
              {
                (void)printf("%6d", indices[i]);
                if (++j == 5)
                {
                  (void)printf("\n");
                  j = 0;
                }
              }
            }
          }
        } /* end of loop on variables */
        vars = GTXClientFreeStringArray(nb_var, vars);
      } /* end of loop on files */
      files = GTXClientFreeStringArray(nb_file, files);
    } /* end of loop on directories */
    dirs = GTXClientFreeStringArray(nb_dir, dirs);
    (void)puts("\n");
  } /* end of loop on studies */

  error = 1;
label_end:
  /*
  ** Disconnect from the server
  */
  alpha_indices = GTXClientFreeStringArray(nb_indices,alpha_indices);
  studies = GTXClientFreeStringArray(nb_study, studies);
  dirs = GTXClientFreeStringArray(nb_dir, dirs);
  files = GTXClientFreeStringArray(nb_file, files);
  vars = GTXClientFreeStringArray(nb_var, vars);
  GTXClientDisconnect();

  return(error);
}
