/*****************************************************************************
 
            Copyright (c)2005 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/
 
/* $Id: vendor_data_read.c 11506 2008-01-08 19:16:38Z foucher $ */
 
#include <GTXClient.h>

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#if defined (winnt) || defined (linux)
#include <string.h>
#else
#include <strings.h>
#endif

#include "vendor_data.h"

int main(int argc, char argv[])
{
  int i,my_int,version;
  double my_double;
  char *my_string;
  int nval,*int_array;
  double *dbl_array;
  char **string_array;
  GTXVendorData vendor_data = NULL;
  char data_path[1024];
  unsigned short port = 0;

  (void)strcpy(data_path, "");

  if (GTXClientInitialize(GTX_CLIENT_VERSION))
  {
    (void)fprintf(stderr,"Cannot initialize GTXClient library\n");
    exit(1);
  }
  port = 0;
  if (GTXClientRunGTXserver(&port))
  {
    (void)fprintf(stderr,"Cannot run GTXserver\n");
    exit(1);
  }
  if (GTXClientConnect("localhost", port, data_path)) 
  {
    (void)fprintf(stderr,"Cannot connect to GTXserver\n");
    exit(1);
  }
  if (GTXClientSetStudy(GTX_STUDY) ||
      GTXClientSetDirectory(GTX_DIR) ||
      GTXClientSetFile(GTX_FILE))
  {
    printf("Cannot set %s:%s/%s\n", GTX_STUDY, GTX_DIR, GTX_FILE);
    exit(1);
  }
  if (GTXClientSetVariable(GTX_VAR))
  {
    printf("Error setting variable \"%s\"\n", GTX_VAR);
    exit(1);
  }

  /* Read previously written vendor data */
  if (GTXClientVendorDataRead(VENDOR_DATA_NAME, 3, &vendor_data, &version))
  {
    printf("Cannot read Vendor Data in Study level ");
    exit(1);
  }
  printf("version is %d\n", version);
  printf("wanted version %d\n", VENDOR_DATA_VERSION);

  GTXClientVendorDataGetAttributeInt(vendor_data, VENDOR_DATA_ATTR_INT, &my_int);
  printf("my_int is %d\n", my_int);

  GTXClientVendorDataGetAttributeDouble(vendor_data, VENDOR_DATA_ATTR_DOUBLE, &my_double);
  printf("my_double is %g\n", my_double);

  GTXClientVendorDataGetAttributeString(vendor_data, VENDOR_DATA_ATTR_STRING,
                                        &my_string);
  printf("my_string is %s\n", my_string);
  my_string = GTXClientFreePointer(my_string);

  GTXClientVendorDataGetAttributeIntArray(vendor_data, VENDOR_DATA_ATTR_INT_ARRAY, &nval,
                                          &int_array);
  printf("Ints has %d values:\n", nval);
  for (i = 0; i < nval; i++)
    printf("Ints[%d] = %d\n", i, int_array[i]);
  int_array = GTXClientFreePointer(int_array);

  GTXClientVendorDataGetAttributeDoubleArray(vendor_data, VENDOR_DATA_ATTR_DOUBLE_ARRAY, &nval,
                                             &dbl_array);
  printf("Dbls has %d values:\n", nval);
  for (i = 0; i < nval; i++)
    printf("Dbls[%d] = %g\n", i, dbl_array[i]);
  dbl_array = GTXClientFreePointer(dbl_array);

  GTXClientVendorDataGetAttributeStringArray(vendor_data, VENDOR_DATA_ATTR_STRING_ARRAY, &nval,
                                             &string_array);
  printf("Strs has %d values:\n", nval);
  for (i = 0; i < nval; i++)
  {
    printf("Strs[%d] = %s\n", i, string_array[i]);
  }
  string_array = GTXClientFreeStringArray(nval, string_array);

  vendor_data = GTXClientVendorDataFree(vendor_data);

  GTXClientDisconnect();

  return (0);
}
