/*****************************************************************************
 
            Copyright (c)2005 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/
 
/* $Id: vendor_data_write.c 11537 2008-01-10 16:26:18Z foucher $ */
 
#include <GTXClient.h>

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#if defined (winnt) || defined (linux)
#include <string.h>
#else
#include <strings.h>
#endif

#ifdef winnt
#define strdup _strdup
#endif

#include "vendor_data.h"

int main(int argc, char argv[])
{
  char **my_string_array;
  int int_tab[10] = {0,1,2,3,4,5,6,7,8,9};
  double dbl_tab[10] = {0.,1.,2.,3.,4.,5.,6.,7.,8.,9.};
  GTXVendorData vendor_data = NULL;
  char data_path[1024];
  unsigned short port;

  (void)strcpy(data_path, "");

  if (GTXClientInitialize(GTX_CLIENT_VERSION))
  {
    (void)fprintf(stderr,"Cannot initialize GTXClient library\n");
    exit(1);
  }
  port = 0;
  if (GTXClientRunGTXserver(&port))
  {
    (void)fprintf(stderr,"Cannot run GTXserver\n");
    exit(1);
  }
  if (GTXClientConnect("localhost", port, data_path)) 
  {
    (void)fprintf(stderr,"Cannot connect to GTXserver\n");
    exit(1);
  }
  if (GTXClientSetStudy(GTX_STUDY) ||
      GTXClientSetDirectory(GTX_DIR) ||
      GTXClientSetFile(GTX_FILE))
  {
    printf("Cannot set %s:%s/%s\n", GTX_STUDY, GTX_DIR, GTX_FILE);
    exit(1);
  }
  if (GTXClientSetVariable(GTX_VAR))
  {
    printf("Error setting variable \"%s\"\n", GTX_VAR);
    exit(1);
  }

  vendor_data = GTXClientVendorDataNew(VENDOR_DATA_NAME, VENDOR_DATA_VERSION);
    
  GTXClientVendorDataAddAttributeInt(vendor_data, VENDOR_DATA_ATTR_INT, 100);

  GTXClientVendorDataAddAttributeDouble(vendor_data, VENDOR_DATA_ATTR_DOUBLE, 2);

  GTXClientVendorDataAddAttributeString(vendor_data, VENDOR_DATA_ATTR_STRING, "COUCOU");

  GTXClientVendorDataAddAttributeIntArray(vendor_data, VENDOR_DATA_ATTR_INT_ARRAY, 10, int_tab);
  GTXClientVendorDataAddAttributeDoubleArray(vendor_data, VENDOR_DATA_ATTR_DOUBLE_ARRAY, 10, dbl_tab);

  my_string_array = malloc(sizeof(char*)*3);
  my_string_array[0] = (char*)strdup("Chaine 1");
  my_string_array[1] = (char*)strdup("Chaine 2");
  my_string_array[2] = (char*)strdup("Chaine 3");
  GTXClientVendorDataAddAttributeStringArray(vendor_data, VENDOR_DATA_ATTR_STRING_ARRAY, 3,
                                             (const char * const *)my_string_array);

  if (GTXClientVendorDataWrite(3, vendor_data))
  {
    printf("Cannot write Vendor Data");
    exit(1);
  }

  /* Free allocated memory */
  free(my_string_array[0]);
  free(my_string_array[1]);
  free(my_string_array[2]);
  free(my_string_array);
  vendor_data = GTXClientVendorDataFree(vendor_data);

  GTXClientDisconnect();

  return (0);
}
