/*****************************************************************************
 
            Copyright (c)2005 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/
 
/* $Id: write_fault.c 11506 2008-01-08 19:16:38Z foucher $ */
 
#include <GTXClient.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define GTX_STUDY    "GTXserver_Tests"
#define GTX_DIR      "write"
#define GTX_FILE     "grid + fault"
#define GTX_VARIABLE "variable"

#define DEFAULT_GTX_SERVERNAME "localhost"

#define MAX_HOSTNAME_LEN 1024
#define MAX_PATH_LEN     1024

char *GTXvar_types[] =
{
  "Float",
  "Character",
  "X gravity center",
  "Y gravity center",
  "Z gravity center",
  "Macro"
};

/*****************************************************************************
**
** FUNCTION:    st_usage
**
** DESCRIPTION: gives this program usage
**
** RETURNS:     Nothing
**
** ARGUMENTS:   int help : 1 to obtain a complete help
**
*****************************************************************************/
static void st_usage(char *exe_name,
                     int help)
{
  (void)printf("Usage: %s [-help] [-host hostname] [-port port_number]\n",
               exe_name);
  (void)printf("          [-path data_path]");

  if (help)
  {
    (void)printf(" -help             : Print this message.\n");
    (void)printf(" -debug            : Print client/server messages.\n");
    (void)printf(" -host hostname    : Server's hostname.\n");
    (void)printf(" -port port_number : Port used between client and server\n");
    (void)printf(" -path data_path   : Initialize connection with given data_path.\n");
    (void)printf("The default is to run a new server on a random port.");
    (void)printf("If -host or -port is specified, a server must have been started first on the given host/port");
  }
}

/****************************************************************************
**
** FUNCTION:    main
**
** DESCRIPTION: client's main function
**
** RETURNS:     Nothing
**
** ARGUMENTS:   int argv, char *argv : program arguments
**
*****************************************************************************/
int main(int argc,
         char *argv[])
{
  char *tmp_str, host[MAX_HOSTNAME_LEN];
  unsigned short port;
  int i,error,run_server;
  char data_path[MAX_PATH_LEN];

  GTXFaultSystem fsystem;
  double *array = NULL;
  fsystem.faults = NULL;

  error = 1;
  run_server = 1;
  port = GTXClientGetDefaultPort();

  (void)strcpy(host, DEFAULT_GTX_SERVERNAME);
  (void)strcpy(data_path, "");

  for (i=1; i<argc; i++)
  {
    if (!strcmp(argv[i], "-port"))
    {
      i++;
      if (i<argc)
      {
        run_server = 0;
        port = (unsigned short)strtol(argv[i], &tmp_str, 10);
        if (port == 0 && tmp_str == argv[i])
        {
          (void)fprintf(stderr,"Invalid Port Number.");
          exit(1);
        }
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-host"))
    {
      i++;
      if (i<argc)
      {
        run_server = 0;
        if (strlen(argv[i]) > MAX_HOSTNAME_LEN-1)
        {
          (void)fprintf(stderr,"Host Name must contain less than %d characters.",
                        MAX_HOSTNAME_LEN);
          exit(1);
        }
        (void)strcpy(host, argv[i]);
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-path"))
    {
      i++;
      if (i<argc)
      {
        if (strlen(argv[i]) > MAX_PATH_LEN-1)
        {
          (void)fprintf(stderr,"Path must contain less than %d characters.",
                        MAX_PATH_LEN);
          exit(1);
        }
        (void)strcpy(data_path, argv[i]);
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-debug"))
      GTXClientDebug(1);
    else if (!strcmp(argv[i], "-help"))
    {
      st_usage(argv[0], 1);
      exit(0);
    }
  }

  /*
  ** Connect to the server
  */
  if (GTXClientInitialize(GTX_CLIENT_VERSION))
    goto label_end;
  if (run_server)
  {
    port = 0;
    if (GTXClientRunGTXserver(&port))
      goto label_end;
  }
  if (GTXClientConnect(host, port, data_path))
    goto label_end;

  /*
  ** Set current study
  */
  if (GTXClientSetStudy(GTX_STUDY))
    goto label_end;

  /*
  ** Set current study
  */
  if (GTXClientSetDirectory(GTX_DIR))
    goto label_end;

  /*
  ** Create a new grid file
  */
  if (GTXClientNewGridFile(GTX_FILE, 2, 0., 0., 0., 10., 10., 0., 10, 10, 0))
     goto label_end;

  /*
  ** Set current file
  */
  if (GTXClientSetFile(GTX_FILE))
    goto label_end;
 
  /*
  ** Create a variable
  */
  if (GTXClientNewDoubleVariable(GTX_VARIABLE, 64, GTX_FORMAT_TYPE_DECIMAL,
                                 10, 6, NULL))
    goto label_end;

  /*
  ** Set the current variable
  */
  if (GTXClientSetVariable(GTX_VARIABLE))
    goto label_end;

  /*
  ** Write data in the variable
  */
  array = (double*)malloc(10*10*sizeof(double));
  if (array == NULL) goto label_end;
  for (i=0; i<10*10; i++) array[i] = (double)i;

  if (GTXClientWriteDoubleVariable(0, -9999., 10*10, array))
    goto label_end;

  /*
  ** Create & Write fault attached to this file
  */
  fsystem.faults_2d = 1;
  fsystem.aux_var_used = 0;
  fsystem.aux_var_test = -9999.999;
  fsystem.n_faults = 1;
  fsystem.faults = (GTXFault*)calloc(fsystem.n_faults, sizeof(GTXFault)); 
  strcpy(fsystem.faults->name, "MyFault");
  fsystem.faults->polygon = 1;
  fsystem.faults->n_segments = 3;
  fsystem.faults->segments = (GTXFaultSegment*)calloc(fsystem.faults->n_segments,
                                                      sizeof(GTXFaultSegment));
  fsystem.faults->segments[0].X1 = 10.0;
  fsystem.faults->segments[0].Y1 = 10.0;
  fsystem.faults->segments[0].X2 = 80.0;
  fsystem.faults->segments[0].Y2 = 10.0;
  fsystem.faults->segments[0].priority = 1;
  fsystem.faults->segments[1].X1 = 80.0;
  fsystem.faults->segments[1].Y1 = 10.0;
  fsystem.faults->segments[1].X2 = 40.0;
  fsystem.faults->segments[1].Y2 = 80.0;
  fsystem.faults->segments[1].priority = 1;
  fsystem.faults->segments[2].X1 = 40.0;
  fsystem.faults->segments[2].Y1 = 80.0;
  fsystem.faults->segments[2].X2 = 10.0;
  fsystem.faults->segments[2].Y2 = 10.0;
  fsystem.faults->segments[2].priority = 1;

  if (GTXClientWriteFaults(&fsystem)) goto label_end;

  error = 1;

label_end:
  if (array) free(array);

  if (fsystem.faults)
  {
    for (i=0; i<fsystem.n_faults; i++)
      if (fsystem.faults[i].segments)
        free(fsystem.faults[i].segments);
    free(fsystem.faults);
  }

  /*
  ** Disconnect from the server
  */
  GTXClientDisconnect();

  return(error);
}
