/*****************************************************************************
 
            Copyright (c)2005 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/
 
/* $Id: write_polygon.c 11564 2008-01-14 15:29:44Z marin $ */
 
#include <GTXClient.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define GTX_STUDY    "GTXserver_Tests"
#define GTX_DIR      "polygons"
#define GTX_FILE     "polygons"

#define DEFAULT_GTX_SERVERNAME "localhost"

#define MAX_HOSTNAME_LEN 1024
#define MAX_PATH_LEN     1024

char *GTXvar_types[] =
{
  "Float",
  "Character",
  "X gravity center",
  "Y gravity center",
  "Z gravity center",
  "Macro"
};

double x_center[] = { 0., -2.5, +2.5, +2.5, -2.5 };
double y_center[] = { 0., -2.5, -2.5, +2.5, +2.5 };

/*****************************************************************************
**
** FUNCTION:    st_usage
**
** DESCRIPTION: gives this program usage
**
** RETURNS:     Nothing
**
** ARGUMENTS:   int help : 1 to obtain a complete help
**
*****************************************************************************/
static void st_usage(char *exe_name,
                     int help)
{
  (void)printf("Usage: %s [-help] [-host hostname] [-port port_number]\n",
               exe_name);
  (void)printf("          [-path data_path]");

  if (help)
  {
    (void)printf(" -help             : Print this message.\n");
    (void)printf(" -debug            : Print client/server messages.\n");
    (void)printf(" -host hostname    : Server's hostname.\n");
    (void)printf(" -port port_number : Port used between client and server\n");
    (void)printf(" -path data_path   : Initialize connection with given data_path.\n");
    (void)printf("The default is to run a new server on a random port.");
    (void)printf("If -host or -port is specified, a server must have been started first on the given host/port");
  }
}

/****************************************************************************
**
** FUNCTION:    main
**
** DESCRIPTION: client's main function
**
** RETURNS:     Nothing
**
** ARGUMENTS:   int argv, char *argv : program arguments
**
*****************************************************************************/
int main(int argc,
         char *argv[])
{
  char *tmp_str, host[MAX_HOSTNAME_LEN];
  unsigned short port;
  int i, error, run_server, exists;
  char data_path[MAX_PATH_LEN];

  GTXPolygonSystem psystem;
  GTXPolygon *poly;
  
  error = 1;
  run_server = 1;
  psystem.polygons = NULL;
  port = GTXClientGetDefaultPort();

  (void)strcpy(host, DEFAULT_GTX_SERVERNAME);
  (void)strcpy(data_path, "");

  for (i=1; i<argc; i++)
  {
    if (!strcmp(argv[i], "-port"))
    {
      i++;
      if (i<argc)
      {
        run_server = 0;
        port = (unsigned short)strtol(argv[i], &tmp_str, 10);
        if (port == 0 && tmp_str == argv[i])
        {
          (void)fprintf(stderr,"Invalid Port Number.");
          exit(1);
        }
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-host"))
    {
      i++;
      if (i<argc)
      {
        run_server = 0;
        if (strlen(argv[i]) > MAX_HOSTNAME_LEN-1)
        {
          (void)fprintf(stderr,"Host Name must contain less than %d characters.",
                        MAX_HOSTNAME_LEN);
          exit(1);
        }
        (void)strcpy(host, argv[i]);
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-path"))
    {
      i++;
      if (i<argc)
      {
        if (strlen(argv[i]) > MAX_PATH_LEN-1)
        {
          (void)fprintf(stderr,"Path must contain less than %d characters.",
                        MAX_PATH_LEN);
          exit(1);
        }
        (void)strcpy(data_path, argv[i]);
      }
      else
      {
        st_usage(argv[0], 0);
        exit(1);
      }
    }
    else if (!strcmp(argv[i], "-debug"))
      GTXClientDebug(1);
    else if (!strcmp(argv[i], "-help"))
    {
      st_usage(argv[0], 1);
      exit(0);
    }
  }

  /*
  ** Connect to the server
  */
  if (GTXClientInitialize(GTX_CLIENT_VERSION))
    goto label_end;
  if (run_server)
  {
    port = 0;
    if (GTXClientRunGTXserver(&port))
      goto label_end;
  }
  if (GTXClientConnect(host, port, data_path))
    goto label_end;

  /*
  ** Set current study
  */
  if (GTXClientSetStudy(GTX_STUDY))
    goto label_end;

  /*
  ** Set current directory
  */
  if (GTXClientDirectoryExists(GTX_DIR, &exists))
    goto label_end;
  if (!exists && GTXClientNewDirectory(GTX_DIR))
    goto label_end;
  if (GTXClientSetDirectory(GTX_DIR))
    goto label_end;

  /*
  ** Create a polygon system structure
  */
  psystem.polygons_2d = 1;
  psystem.ext_min[0] = psystem.ext_min[1] = -3.;
  psystem.ext_max[0] = psystem.ext_max[1] = 3.;
  psystem.ext_min[2] = psystem.ext_max[2] = 0.;
  psystem.n_polygons = 5;
  psystem.polygons = (GTXPolygon*)calloc(psystem.n_polygons, sizeof(GTXPolygon));
  if (psystem.polygons == NULL) goto label_end;

  poly = &psystem.polygons[0];
  strcpy(poly->name, "Poly_0");
  poly->n_vertices = 4;
  poly->vertices = (double*)calloc(poly->n_vertices*2, sizeof(double));
  if (poly->vertices == NULL) goto label_end;
  poly->vertices[0*2+0] = -1.;
  poly->vertices[0*2+1] = -1.;
  poly->vertices[1*2+0] = 1.;
  poly->vertices[1*2+1] = -1.;
  poly->vertices[2*2+0] = 1.;
  poly->vertices[2*2+1] = 1.;
  poly->vertices[3*2+0] = -1.;
  poly->vertices[3*2+1] = 1.;

  for (i=1; i<psystem.n_polygons; i++)
  {
    poly = &psystem.polygons[i];
    sprintf(poly->name, "Poly_%d", i);
    strcpy(poly->group_name, "Group_1");
    poly->n_vertices = 4;
    poly->vertices = (double*)calloc(poly->n_vertices*2, sizeof(double));
    if (poly->vertices == NULL) goto label_end;
    poly->vertices[0*2+0] = x_center[i] - 0.5;
    poly->vertices[0*2+1] = y_center[i] - 0.5;
    poly->vertices[1*2+0] = x_center[i] + 0.5;
    poly->vertices[1*2+1] = y_center[i] - 0.5;
    poly->vertices[2*2+0] = x_center[i] + 0.5;
    poly->vertices[2*2+1] = y_center[i] + 0.5;
    poly->vertices[3*2+0] = x_center[i] - 0.5;
    poly->vertices[3*2+1] = y_center[i] + 0.5;
  }

  if (GTXClientNewPolygonsFile(GTX_FILE, &psystem))
    goto label_end;
  
  error = 0;

label_end:

  if (psystem.polygons)
  {
    for (i=0; i<psystem.n_polygons; i++)
      if (psystem.polygons[i].vertices)
        free(psystem.polygons[i].vertices);
    free(psystem.polygons);
  }
      
  /*
  ** Disconnect from the server
  */
  GTXClientDisconnect();

  return(error);
}
