/*****************************************************************************
 
            Copyright (c)2008 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/
 
/* This example uses Trolltech/Qt (see http://trolltech.com) framework */

/* $Id$ */

#include <QApplication>
#include <QFileDialog>
#include <QTreeWidgetItem>
#include <QMenu>
#include <GTXError.hpp>
#include "browser.hpp"
#include <stdio.h>

#include "utils.hpp"


Browser::Browser(QWidget *parent)
  : QMainWindow(parent)
{
  setupUi(this);
  runServer = true;

  //Use if runServer
  forcepath = false;
  serverpath = "";
  
  //Use if !runServer
  host = "localhost";
  port = client.GetDefaultPort();
  datapath = "";
  spinBoxPort->setMaximum(65636);
  spinBoxPort->setValue(port);

  lineEditHost->setText(host);

  treeWidget->setContextMenuPolicy(Qt::CustomContextMenu);
  listMacroWidget->setContextMenuPolicy(Qt::CustomContextMenu);
}

void Browser::on_radioRunGTXserver_toggled(bool on)
{
  runServer = on;
}

void Browser::on_spinBoxPort_valueChanged(int val)
{
  port = val;
}

void  Browser::on_checkForcePath_toggled(bool on)
{
  forcepath = on;
}
void Browser::on_toolButtonGTXserverPath_clicked()
{

  serverpath = QFileDialog::getExistingDirectory(this, tr("PathSelector"), serverpath);
  lineEditGTXserverPath->setText(serverpath);
}


void Browser::on_pbuConnect_clicked()
{
  try{
    

    if (runServer){
      port = client.RunGTXserver(0);
      if(!forcepath)
        serverpath = "";
      host = "localhost";
      datapath = "";

    }else{
      serverpath = "";
    }


    client.Connect(qPrintable(host),port,qPrintable(datapath));
    
    /*Fill the file selector with study*/
    GTXStringArray list =  client.GetStudyList();

    treeWidget->setColumnCount(1);
    
    for (int i = 0; i < list.GetCount(); ++i)
    {
      QTreeWidgetItem *item = new QTreeWidgetItem(treeWidget, QStringList(QString(list.GetValue(i))));
      item->setChildIndicatorPolicy(QTreeWidgetItem::ShowIndicator);
    }
    
    
  }catch(GTXError e){
    fprintf(stderr, "GTXClient returned an error:\n  %s\n",
            e.GetMessage());
  }
}

int Browser::SetFromNode(QTreeWidgetItem *item)
{

  study     = "";
  directory = "";
  file      = "";
  variable  = "";
  
  int level = 1;
  QTreeWidgetItem *parent = item;
  while ((parent = parent->parent()) != NULL)
    level++;

  switch (level)
  {
    case 1:
      study = item->text(0);
      break;
    case 2:
      study     = item->parent()->text(0);
      directory = item->text(0);
      break;
    case 3:
      study     = item->parent()->parent()->text(0);
      directory = item->parent()->text(0);
      file      = item->text(0);
      break;
    case 4:
      study     = item->parent()->parent()->parent()->text(0);
      directory = item->parent()->parent()->text(0);
      file      = item->parent()->text(0);
      variable  = item->text(0);
      break;
  }
  client.SetStudy(qPrintable(study));
  if (!directory.isEmpty()) 
  {
    client.SetDirectory(qPrintable(directory));
    if (!file.isEmpty())
    {
      client.SetFile(qPrintable(file));
      if (!variable.isEmpty())
        client.SetVariable(qPrintable(variable));
    }
  }
  return (level);
}


void Browser::on_treeWidget_itemClicked(QTreeWidgetItem *item, int)
{
  char tmp[20];

  listMacroWidget->clear();

  int level = SetFromNode(item);
  if (level != 4)
    return;

  if (client.GetVariableInfo().GetVariableType() == GTXVariableInfo::VAR_TYPE_MACRO){

    GTXStringArray listMacroAlpha =  client.GetMacroAlphaIndices();
    if (listMacroAlpha.GetCount())
    {
      for (int i = 0; i<listMacroAlpha.GetCount(); i++){
        listMacroWidget->addItem(tr(listMacroAlpha.GetValue(i)));
      }
    }
    else
    {
      GTXIntArray listMacroInt = client.GetMacroIndices();
      for (int i = 0; i<listMacroInt.GetCount(); i++){
        sprintf(tmp, "%d",listMacroInt.GetValue(i) );
        listMacroWidget->addItem(tr(tmp));
      }
    }
  }
  
}

void Browser::on_listMacroWidget_itemClicked(QListWidgetItem *item)
{
  int current_indice = 0;
  GTXStringArray listMacroAlpha =  client.GetMacroAlphaIndices();
  GTXIntArray listMacroInt = client.GetMacroIndices();

  if (listMacroAlpha.GetCount()){
    
    //Looking for the rank of the alphanemuric data.
    client.SetAlphaIndice(qPrintable(item->text()));
                     
  }else{
    current_indice = atoi(qPrintable(item->text()));
    client.SetIndice(current_indice);
    

  }
  
}

void Browser::on_listMacroWidget_customContextMenuRequested(const QPoint &pos)
{
  try{
    QListWidgetItem *item = listMacroWidget->itemAt(pos);
    if (item == NULL) return;
    

    QMenu *menu = new QMenu(this);
    menu->addAction("Information");
    menu->addAction("Statistics");
    QAction *action = menu->exec(listMacroWidget->mapToGlobal(pos));

    if (action == NULL)
      return;
    if (action->text() == "Information"){
      if (variable.isEmpty() && !file.isEmpty())
        textEditMessages->setPlainText(QString(InfoDump::FileInfo(&client,0).c_str()));
      else if (!variable.isEmpty())
        textEditMessages->setPlainText(QString(InfoDump::VariableInfo(&client,0,0).c_str()));
    }else if (action->text() == "Statistics"){
       if (!variable.isEmpty())
        textEditMessages->setPlainText(QString(InfoDump::VariableInfo(&client,2,0).c_str()));
    }
    
    
  }catch(GTXError e){
    fprintf(stderr, "GTXClient returned an error:\n  %s\n",
            e.GetMessage());
  }
}











void Browser::on_treeWidget_itemExpanded(QTreeWidgetItem *item)
{
  int level = SetFromNode(item);
  GTXStringArray list;
  switch (level)
  {
    case 1:
      list =  client.GetDirectoryList();
      break;
    case 2:
      list =  client.GetFileList();
      break;
    case 3:
      list =  client.GetVariableList();
      break;
    case 4:
      break;
  }

  while (item->childCount() > 0)
    item->removeChild(item->child(0));
  for (int i = 0; i < list.GetCount(); ++i)
  {
    QTreeWidgetItem *nitem = new QTreeWidgetItem(item, QStringList(QString(list.GetValue(i))));
    if (level < 3)
      nitem->setChildIndicatorPolicy(QTreeWidgetItem::ShowIndicator);
  }
}

void Browser::on_treeWidget_customContextMenuRequested(const QPoint &pos)
{
  try{
    QTreeWidgetItem *item = treeWidget->itemAt(pos);
    if (item == NULL) return;
    
    QMenu *menu = new QMenu(this);
    menu->addAction("Information");
    menu->addAction("Statistics");
    QAction *action = menu->exec(treeWidget->mapToGlobal(pos));
    
    if (action == NULL)
      return;
    if (action->text() == "Information"){
      if (variable.isEmpty() && !file.isEmpty())
        textEditMessages->setPlainText(QString(InfoDump::FileInfo(&client,0).c_str()));
      else if (!variable.isEmpty())
        textEditMessages->setPlainText(QString(InfoDump::VariableInfo(&client,0,0).c_str()));
    }else if (action->text() == "Statistics"){
       if (!variable.isEmpty())
        textEditMessages->setPlainText(QString(InfoDump::VariableInfo(&client,1,0).c_str()));
    }
  }catch(GTXError e){
    fprintf(stderr, "GTXClient returned an error:\n  %s\n",
            e.GetMessage());
  }
}

void Browser::on_lineEditGTXserverPath_editingFinished()
{
  serverpath = lineEditGTXserverPath->text();
}

void Browser::on_lineEditHost_editingFinished()
{
  host = lineEditHost->text();
}

void Browser::on_lineEditDataPath_editingFinished()
{
  datapath = lineEditDataPath->text();
}



int main(int argc,
         char *argv[])
{
  QApplication app(argc, argv);

  Browser browser;
  browser.show();

  return app.exec();
}

