#ifndef __Browser_hpp__
#define __Browser_hpp__

#include <GTXClient.hpp>
#include "ui_browser.h"

class Browser: public QMainWindow, private Ui::BrowserUI
{
  Q_OBJECT

public:
  Browser(QWidget *parent = 0);

private:
  bool runServer;

  //Use if runServer
  bool forcepath;
  QString serverpath;
  
  //Use if !runServer
  QString host;
  unsigned short int port;
  QString datapath;

  //GTX Objtects
  GTXClient client;

  // Set current study/dir/file/var from clicked item and return item level
  int SetFromNode(QTreeWidgetItem *item);

  QString study;
  QString directory;
  QString file;
  QString variable;



private slots:
  void on_radioRunGTXserver_toggled(bool on);
  void on_checkForcePath_toggled(bool on);
  void on_pbuConnect_clicked();
  void on_toolButtonGTXserverPath_clicked();
  void on_lineEditGTXserverPath_editingFinished();
  void on_lineEditHost_editingFinished();
  void on_lineEditDataPath_editingFinished();
  void on_treeWidget_itemExpanded(QTreeWidgetItem *item);
  void on_treeWidget_itemClicked(QTreeWidgetItem *item, int colum);
  void on_treeWidget_customContextMenuRequested(const QPoint & pos);
  void on_spinBoxPort_valueChanged(int val);

  void on_listMacroWidget_itemClicked(QListWidgetItem *item);
  void on_listMacroWidget_customContextMenuRequested(const QPoint &pos);


};

#endif
