######################################################################
# Project file to be used with Qt/qmake (qt) then Gnu/Make/Gcc under
#   Unix and Microsoft Visual Studio 2005 NMake under Windows
# make -f Makefile   (under Unix)
# nmake -f Makefile  (under Visual Studio with NMake)
######################################################################

GV_ARCH=$$(GTX_ARCH)
linux-g++: {
  GCC_VERSION=$$system("LANG=C g++ --version | sed -n 's/g++ (GCC) \\(.\\).\\(.\\).*/\1\2'/p")
  # only gcc 3.4 and gcc 4.1 distributed
  greaterThan(GCC_VERSION,41): GCC_VERSION=41
  isEmpty(GV_ARCH): GV_ARCH = linux-gcc$$GCC_VERSION
}
linux-g++-64: {
  GCC_VERSION=$$system("LANG=C g++ --version | sed -n 's/g++ (GCC) \\(.\\).\\(.\\).*/\1\2'/p")
  # only gcc 3.4 and gcc 4.1 distributed
  greaterThan(GCC_VERSION,41): GCC_VERSION=41
  isEmpty(GV_ARCH): GV_ARCH = linux64-gcc$$GCC_VERSION
}
win32-msvc2005: isEmpty(GV_ARCH): GV_ARCH = winnt
solaris-cc-64:  isEmpty(GV_ARCH): GV_ARCH = solaris64

TEMPLATE = app
TARGET = 
INCLUDEPATH += . ../../include
LIBS += -L../../lib/$$GV_ARCH/shared -lgtxclient
MOC_DIR = ./$$GV_ARCH
DESTDIR = ./$$GV_ARCH
CONFIG += release

CONFIG(debug, debug|release) {
  TARGET = browser_debug
  OBJECTS_DIR = ./$$GV_ARCH/debug
} else {
  TARGET = browser
  OBJECTS_DIR = ./$$GV_ARCH/release
}

win32 {
DEFINES += _CRT_SECURE_NO_WARNINGS
}

# Input
HEADERS = utils.hpp \
          browser.hpp
SOURCES = browser.cpp
FORMS   = browser.ui

MAKEFILE=Makefile.qt

