#include <GTXClient.hpp>
#include <GTXError.hpp>
#include <stdio.h>

#include "utils.hpp"

int main(int argc,
         char *argv[])
{
  Arguments args;
  args.ParseCommandLine(argc, argv);

  try
  {
    GTXClient *client = new GTXClient();

    /*
    ** Connect to the server
    */
    if (args.run_server)
    {
      args.port = 0;
      args.port = client->RunGTXserver(args.port);
    }
    client->Connect(args.host, args.port, args.data_path);

    GTXStringArray studies = client->GetStudyList();
    for (int istudy = 0; istudy < studies.GetCount(); istudy++)
    {
      printf("- Study: %s\n", studies.GetValue(istudy));
      client->SetStudy(studies.GetValue(istudy));
      GTXStringArray directories = client->GetDirectoryList();
      for (int idir = 0; idir < directories.GetCount(); idir++)
      {
        printf("  - Directory: %s\n", directories.GetValue(idir));
        client->SetDirectory(directories.GetValue(idir));
        GTXStringArray files = client->GetFileList();
        for (int ifile = 0; ifile < files.GetCount(); ifile++)
        {
          printf("    - File: %s\n", files.GetValue(ifile));
          client->SetFile(files.GetValue(ifile));

          puts(InfoDump::FileInfo(client, 6).c_str());

          GTXStringArray vars = client->GetVariableList();
          for (int ivar = 0; ivar < vars.GetCount(); ivar++)
          {
            printf("      - Variable: %s\n", vars.GetValue(ivar));
            client->SetVariable(vars.GetValue(ivar));

            puts(InfoDump::VariableInfo(client, true, 8).c_str());
          }
        }
      }
    }
    client->Disconnect();
  } catch (GTXError e)
  {
    fprintf(stderr, "GTXClient returned an error:\n  %s\n",
            e.GetMessage());
  }
  return (0);
}
