#include <GTXClient.hpp>
#include <GTXError.hpp>
#include <stdio.h>
#include <GTXFaultSystem.hpp>

#define GTX_STUDY        "GTXserver_Tests"
#define GTX_DIR        "FaultDirectory"
#define GTX_FILE       "File"
#define GTX_VARIABLE     "Var"


#include "utils.hpp"
#ifdef winnt
#define GTX_STUDY_PATH "C:\\" GTX_STUDY
#else
#define GTX_STUDY_PATH "/tmp/" GTX_STUDY
#endif


int main(int argc,
         char *argv[])
{
  Arguments args;
  args.ParseCommandLine(argc, argv);


  GTXClient *client = new GTXClient();

  

  try
  {
    
    




    /*
    ** Connect to the server
    */
    if (args.run_server)
    {
      args.port = 0;
      args.port = client->RunGTXserver(args.port);
    }
    client->Connect(args.host, args.port, args.data_path);


    /*Set Study,directory....*/

    bool isStudy = false;
    GTXStringArray list =  client->GetStudyList();
    for (int i = 0; i < list.GetCount(); i++){
      if (strcmp(list.GetValue(i), GTX_STUDY)==0)
        isStudy = true;
    }
    if (!isStudy)
      client->NewStudy(GTX_STUDY, GTX_STUDY_PATH );
    client->SetStudy(GTX_STUDY);
  //search is the Directory existing, else create it and set it
    if (!client->DirectoryExists(GTX_DIR))
      client->NewDirectory(GTX_DIR);
    client->SetDirectory(GTX_DIR);
    //search is the File existing, else create it and set it
    if (!client->FileExists(GTX_FILE))
      client->NewGridFile2D(GTX_FILE,0.,0.,1.,1.,10,10);
    client->SetFile(GTX_FILE);


    //Create a segment
    GTXFaultSegment seg = GTXFaultSegment();
    seg.SetX1(0.);
    seg.SetY1(0.);
    seg.SetZ1(0.);
    seg.SetX2(3.);
    seg.SetY2(3.);
    seg.SetZ2(0.);
    seg.SetX3(1.5);
    seg.SetY3(1.5);
    seg.SetZ3(5);
    seg.SetV1(1);
    seg.SetV2(2);
    seg.SetV3(3);
    seg.SetPriority(50);
    //Create another segment
    GTXFaultSegment seg2 = GTXFaultSegment();
    seg2.SetX1(5.);
    seg2.SetY1(5.);
    seg2.SetZ1(0.);
    seg2.SetX2(10.);
    seg2.SetY2(10.);
    seg2.SetZ2(0.);
    seg2.SetX3(8.);
    seg2.SetY3(8.);
    seg2.SetZ3(7.);
    seg2.SetV1(1);
    seg2.SetV2(2);
    seg2.SetV3(3);
    seg2.SetPriority(50);
    //Create a fault with segments
    GTXFault fault = GTXFault();
    fault.SetName("Fault");
    fault.SetPolygonalFlag(true);
    fault.AddFaultSegment(seg);
    fault.AddFaultSegment(seg2);
    //Create a FaultSystem with faults
    GTXFaultSystem InFaultSystem = GTXFaultSystem();
    InFaultSystem.SetFaults2DFlag(false);
    InFaultSystem.SetAuxiliaryVarUsedFlag(true);
    InFaultSystem.SetAuxiliaryVarTest(-9999.99);
    InFaultSystem.AddFault( fault );
    //Write Fault
    client->WriteFaults(InFaultSystem);

        
    // Read and print all about the Fault System
    GTXFaultSystem RetFaultSystem = 
      client->ReadFaults(client->GetFileInfo().GetFaultInfo().GetAuthorizedPriority());

    printf("\nFault System:\n\n");

    if(RetFaultSystem.GetFaults2DFlag())
      printf("Faults2dFlag is on \n\n");
    if(RetFaultSystem.GetAuxiliaryVarUsedFlag())
      printf("GetAuxiliaryVarUsedFlag is on \n\n");
              
    printf("AuxiliaryVarTest is %g\n" , RetFaultSystem.GetAuxiliaryVarTest() );
    printf("FaultsNumber is %d\n" , RetFaultSystem.GetFaultsNumber() );

    for(int i = 0; i<RetFaultSystem.GetFaultsNumber();i++){
      printf("\nFault :\n\n");
      printf(" Name:  %s\n",RetFaultSystem.GetFault(i).GetName());
      if(RetFaultSystem.GetFault(i).GetPolygonalFlag())
        printf(" Polygonal Flag is on\n");
      printf(" Segment Number: %d \n",RetFaultSystem.GetFault(i).GetSegmentsNumber());
                
      for(int j = 0; j<RetFaultSystem.GetFault(i).GetSegmentsNumber();j++){
        printf("\n FaultSegment n%d\n",j);
        printf("  X1:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetX1());
        printf("  Y1:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetY1());
        printf("  Z1:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetZ1());
        printf("  X2:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetX2());
        printf("  Y2:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetY2());
        printf("  Z2:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetZ2());
        printf("  X3:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetX3());
        printf("  Y3:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetY3());
        printf("  Z3:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetZ3());
        printf("  V1:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetV1());
        printf("  V2:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetV2());
        printf("  V3:%g\n",RetFaultSystem.GetFault(i).GetSegment(j).GetV3());
        printf("  Priority:%d\n",RetFaultSystem.GetFault(i).GetSegment(j).GetPriority());



      }
    }

    
    
    client->Disconnect();
  } catch (GTXError e)
  {
    fprintf(stderr, "GTXClient returned an error:\n  %s\n",
            e.GetMessage());
  }
  return (0);
}
