#include <GTXClient.hpp>
#include <GTXError.hpp>
#include <stdio.h>
#include <GTXFaultSystem.hpp>

#define GTX_STUDY        "GTXserver_Tests"
#define GTX_DIR        "PolygonDirectory"
#define GTX_FILE       "File"
#define GTX_VARIABLE     "Var"


#include "utils.hpp"
#ifdef winnt
#define GTX_STUDY_PATH "C:\\" GTX_STUDY
#else
#define GTX_STUDY_PATH "/tmp/" GTX_STUDY
#endif


int main(int argc,
         char *argv[])
{
  Arguments args;
  args.ParseCommandLine(argc, argv);

  GTXClient *client = new GTXClient();

  try
  {
    /*
    ** Connect to the server
    */
    if (args.run_server)
    {
      args.port = 0;
      args.port = client->RunGTXserver(args.port);
    }
    client->Connect(args.host, args.port, args.data_path);

    /*Set Study,directory....*/

    bool isStudy = false;
    GTXStringArray list =  client->GetStudyList();
    for (int i = 0; i < list.GetCount(); i++){
      if (strcmp(list.GetValue(i), GTX_STUDY)==0)
        isStudy = true;
    }
    if (!isStudy)
      client->NewStudy(GTX_STUDY, GTX_STUDY_PATH);
    client->SetStudy(GTX_STUDY);

    //search is the Directory existing, else create it and set it
    if (!client->DirectoryExists(GTX_DIR))
      client->NewDirectory(GTX_DIR);
    client->SetDirectory(GTX_DIR);

    //Create Polygon
    GTXPolygon poly = GTXPolygon();
    poly.SetName("Polygon1");
    poly.SetGroupName("Group1");
    poly.SetZMin(-50.);       
    poly.SetZMax(50.);
    poly.AddVertex(0., 0.);
    poly.AddVertex(10., 0.);
    poly.AddVertex(10., 10.);
    poly.AddVertex(0., 10.);
    //Create another Polygon
    GTXPolygon poly2 = GTXPolygon();
    poly2.SetName("Polygon2");
    poly2.SetGroupName("Group1");
    poly2.SetZMin(-5.);       
    poly2.SetZMax(5.);
    poly2.AddVertex(-5., -5.);
    poly2.AddVertex(1., 0.);
    poly2.AddVertex(1., 1.);

    //Create Polygon System
    GTXPolygonSystem polysys = GTXPolygonSystem();
    polysys.SetPolygons2DFlag(true);
    polysys.AddPolygon(poly);
    polysys.AddPolygon(poly2);
        
    //Add to the study
    if (client->FileExists(GTX_FILE)){
      client->SetFile(GTX_FILE);
      client->DeleteFile();
    }
    client->NewPolygonsFile(GTX_FILE,&polysys );
      
    //Read Polygon System
    client->SetFile(GTX_FILE);
    GTXPolygonSystem retpolysys = client->ReadPolygons();

    //Display information about the PolygonSystem read
    if (retpolysys.GetPolygons2DFlag())
      printf("Flag Polygon 2D on\n\n");
    printf("MinimumExtensionX :%g\n",retpolysys.GetMinimumExtensionX());
    printf("MinimumExtensionY :%g\n",retpolysys.GetMinimumExtensionY());
    printf("MinimumExtensionZ :%g\n",retpolysys.GetMinimumExtensionZ());
    printf("MaximumExtensionX :%g\n",retpolysys.GetMaximumExtensionX());
    printf("MaximumExtensionY :%g\n",retpolysys.GetMaximumExtensionY());
    printf("MaximumExtensionZ :%g\n",retpolysys.GetMaximumExtensionZ());
    printf("PolygonsNumber :%d\n",retpolysys.GetPolygonsNumber());

    for (int i = 0; i<retpolysys.GetPolygonsNumber(); i++)
    {
      printf("\n\tName :%s\n" , retpolysys.GetPolygon(i).GetName());
      printf("\tGroupName :%s\n" , retpolysys.GetPolygon(i).GetGroupName());
      printf("\tGetZMin :%g\n" , retpolysys.GetPolygon(i).GetZMin());
      printf("\tGetZMax :%g\n" , retpolysys.GetPolygon(i).GetZMax());
      printf("\tVerticesNumber :%d\n" , retpolysys.GetPolygon(i).GetVerticesNumber());

      printf("\tX\tY\n");        
      for (int j =0; j<retpolysys.GetPolygon(i).GetVerticesNumber(); j++)
        printf("\t%g\t%g\n", retpolysys.GetPolygon(i).GetXVertices(j), retpolysys.GetPolygon(i).GetYVertices(j));
    }
    client->Disconnect();
  } catch (GTXError e)
  {
    fprintf(stderr, "GTXClient returned an error:\n  %s\n",
            e.GetMessage());
  }
  return (0);
}
