#include <GTXClient.hpp>
#include <GTXError.hpp>
#include <stdio.h>
#include <GTXVendorData.hpp>
#include <GTXDoubleArray.hpp>
#include <GTXIntArray.hpp>

#define GTX_STUDY        "GTXserver_Tests"
#define GTX_DIR        "VendorDirectory"
#define GTX_FILE       "File"
#define GTX_VARIABLE     "Var"


#include "utils.hpp"
#ifdef winnt
#define GTX_STUDY_PATH "C:\\" GTX_STUDY
#else
#define GTX_STUDY_PATH "/tmp/" GTX_STUDY
#endif


int main(int argc,
         char *argv[])
{
  Arguments args;
  args.ParseCommandLine(argc, argv);

  GTXClient *client = new GTXClient();

  try
  {

    /*
    ** Connect to the server
    */
    if (args.run_server)
    {
      args.port = 0;
      args.port = client->RunGTXserver(args.port);
    }
    client->Connect(args.host, args.port, args.data_path);


    /*Set Study,directory....*/

    bool isStudy = false;
    GTXStringArray list =  client->GetStudyList();
    for (int i = 0; i < list.GetCount(); i++){
      if (strcmp(list.GetValue(i), GTX_STUDY)==0)
        isStudy = true;
    }
    if (!isStudy)
      client->NewStudy(GTX_STUDY, GTX_STUDY_PATH );
    client->SetStudy(GTX_STUDY);
  //search is the Directory existing, else create it and set it
    if (!client->DirectoryExists(GTX_DIR))
      client->NewDirectory(GTX_DIR);
    client->SetDirectory(GTX_DIR);
    //search is the File existing, else create it and set it
    if (!client->FileExists(GTX_FILE))
      client->NewGridFile2D(GTX_FILE,0.,0.,1.,1.,10,10);
    client->SetFile(GTX_FILE);

    /*Create data for vendor data*/
    /*Create a integer array*/
    GTXIntArray intarray = GTXIntArray();
    intarray.Resize(3);
    intarray.SetValue(0,123);
    intarray.SetValue(1,132);
    intarray.SetValue(2,213);
    /*Create a double array*/
    GTXDoubleArray dblarray = GTXDoubleArray();
    dblarray.Resize(3);
    dblarray.SetValue(0,1.23);
    dblarray.SetValue(1,13.2);
    dblarray.SetValue(2,2.13);
    /*Create a String list*/
    GTXStringArray strlist = GTXStringArray();
    strlist.Resize(3);
    strlist.SetValue(0,"String 1");
    strlist.SetValue(1,"String 2");
    strlist.SetValue(2,"String 3");

    /*Create Vendor Data*/

    GTXVendorData vendorData = GTXVendorData("CPP App",100);
    vendorData.AddAttributeInt("Attribut 0", 100);
    vendorData.AddAttributeDouble("Attribut 1", 200.);
    vendorData.AddAttributeString("Attribut 2", "hello");
    vendorData.AddAttributeIntArray("Attribut 3", intarray);
    vendorData.AddAttributeDoubleArray("Attribut 4", dblarray);
    vendorData.AddAttributeStringArray("Attribut 5", strlist);
    
    // we'll store vendor data at the File level (2)
    int level = 2;
    
    // write the vendor data
    client->VendorDataWrite(level,vendorData);
    
    // read the vendor data back 
    GTXVendorData retvendorData = client->VendorDataRead("Java App",level);

    // retrieve attribute values. They can be retrieved in any order
    int retInt = vendorData.GetAttributeInt("Attribut 0");
    double retDouble = vendorData.GetAttributeDouble("Attribut 1");
    const char*retString = vendorData.GetAttributeString("Attribut 2");
    GTXIntArray retIntArray =
      vendorData.GetAttributeIntArray("Attribut 3");
    GTXDoubleArray retDoubleArray =
      vendorData.GetAttributeDoubleArray("Attribut 4");
    GTXStringArray retStringArray =
      vendorData.GetAttributeStringArray("Attribut 5");

    printf("Retrieved Int Attribute is %d\n" , retInt);
    printf("Retrieved Double Attribute is %f\n" , retDouble);
    printf("Retrieved String Attribute is %s\n" , retString);

    printf("Retrieved Int Array Attribute is\n");
    for (int i = 0; i < retIntArray.GetCount(); i++)
      printf("  %d\n" , retIntArray.GetValue(i));
    printf("Retrieved Double Array Attribute is\n");
    for (int i = 0; i < retDoubleArray.GetCount(); i++)
      printf("  %f\n" , retDoubleArray.GetValue(i));
    printf("Retrieved String Array Attribute is\n");
    for (int i = 0; i < retStringArray.GetCount(); i++)
      printf("  %s\n" , retStringArray.GetValue(i));
    
    client->Disconnect();
  } catch (GTXError e)
  {
    fprintf(stderr, "GTXClient returned an error:\n  %s\n",
            e.GetMessage());
  }
  return (0);
}
