using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using com.geovariances.gtxclient;

	/// <summary>
	/// MainForm contains the code for the interface
	/// </summary>
public class Browser : System.Windows.Forms.Form
{
	GTXClient client;

	private System.Windows.Forms.TreeView GTXTree;
	private System.Windows.Forms.Button Connect;
	private System.Windows.Forms.ContextMenu contextMenu1;
	private System.Windows.Forms.MenuItem InfoMenuItem;
	private System.Windows.Forms.MenuItem StatMenuItem;
	private System.Windows.Forms.GroupBox connectParamsBox;
	private System.Windows.Forms.RadioButton runServerRadio;
	private System.Windows.Forms.RadioButton useRunningServerRadio;
	private System.Windows.Forms.CheckBox ForceGTXserverPathCheck;
	private System.Windows.Forms.Label serverPathLabel;
	private System.Windows.Forms.TextBox serverPathTextBox;
	private System.Windows.Forms.Button serverPathBrowseButton;
	private System.Windows.Forms.Label HostLabel;
	private System.Windows.Forms.TextBox HostTextBox;
	private System.Windows.Forms.Label portLabel;
	private System.Windows.Forms.Label DataLabel;
	private System.Windows.Forms.Button dataBrowse;
	private System.Windows.Forms.TextBox dataTextBox;
	private System.Windows.Forms.RichTextBox infoTextBox;
	private System.Windows.Forms.NumericUpDown portNumeric;
	/// <summary>
	/// Needed by interface builder
	/// </summary>
	private System.ComponentModel.Container components = null;

	/// <summary>
	/// Browser constructor
	/// </summary>
	public Browser()
	{
		client = new GTXClient();
		InitializeComponent();
		this.portNumeric.Value = client.GetDefaultPort();
	}

	/// <summary>
	/// Cleanup
	/// </summary>
	protected override void Dispose( bool disposing )
	{
		if( disposing )
		{
			if (components != null) 
			{
				components.Dispose();
			}
		}
		base.Dispose( disposing );
	}

	#region Code gnr par le Concepteur Windows Form
	/// <summary>
	/// Interface Builder method
	/// </summary>
	private void InitializeComponent()
	{
		this.GTXTree = new System.Windows.Forms.TreeView();
		this.contextMenu1 = new System.Windows.Forms.ContextMenu();
		this.InfoMenuItem = new System.Windows.Forms.MenuItem();
		this.StatMenuItem = new System.Windows.Forms.MenuItem();
		this.Connect = new System.Windows.Forms.Button();
		this.connectParamsBox = new System.Windows.Forms.GroupBox();
		this.dataBrowse = new System.Windows.Forms.Button();
		this.dataTextBox = new System.Windows.Forms.TextBox();
		this.DataLabel = new System.Windows.Forms.Label();
		this.portNumeric = new System.Windows.Forms.NumericUpDown();
		this.portLabel = new System.Windows.Forms.Label();
		this.HostTextBox = new System.Windows.Forms.TextBox();
		this.HostLabel = new System.Windows.Forms.Label();
		this.serverPathBrowseButton = new System.Windows.Forms.Button();
		this.serverPathTextBox = new System.Windows.Forms.TextBox();
		this.serverPathLabel = new System.Windows.Forms.Label();
		this.ForceGTXserverPathCheck = new System.Windows.Forms.CheckBox();
		this.useRunningServerRadio = new System.Windows.Forms.RadioButton();
		this.runServerRadio = new System.Windows.Forms.RadioButton();
		this.infoTextBox = new System.Windows.Forms.RichTextBox();
		this.connectParamsBox.SuspendLayout();
		((System.ComponentModel.ISupportInitialize)(this.portNumeric)).BeginInit();
		this.SuspendLayout();
		// 
		// GTXTree
		// 
		this.GTXTree.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
			| System.Windows.Forms.AnchorStyles.Right)));
		this.GTXTree.ImageIndex = -1;
		this.GTXTree.Location = new System.Drawing.Point(8, 209);
		this.GTXTree.Name = "GTXTree";
		this.GTXTree.SelectedImageIndex = -1;
		this.GTXTree.Size = new System.Drawing.Size(440, 272);
		this.GTXTree.TabIndex = 0;
		this.GTXTree.MouseDown += new System.Windows.Forms.MouseEventHandler(this.GTXTree_MouseDown);
		// 
		// contextMenu1
		// 
		this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																																							 this.InfoMenuItem,
																																							 this.StatMenuItem});
		this.contextMenu1.Popup += new System.EventHandler(this.contextMenu1_Popup);
		// 
		// InfoMenuItem
		// 
		this.InfoMenuItem.Index = 0;
		this.InfoMenuItem.Text = "Information";
		this.InfoMenuItem.Click += new System.EventHandler(this.InfoMenuItem_Click);
		// 
		// StatMenuItem
		// 
		this.StatMenuItem.Index = 1;
		this.StatMenuItem.Text = "Statictics";
		this.StatMenuItem.Click += new System.EventHandler(this.StatMenuItem_Click);
		// 
		// Connect
		// 
		this.Connect.Location = new System.Drawing.Point(352, 88);
		this.Connect.Name = "Connect";
		this.Connect.Size = new System.Drawing.Size(96, 24);
		this.Connect.TabIndex = 2;
		this.Connect.Text = "Connect";
		this.Connect.Click += new System.EventHandler(this.Connect_Click);
		// 
		// connectParamsBox
		// 
		this.connectParamsBox.Controls.Add(this.dataBrowse);
		this.connectParamsBox.Controls.Add(this.dataTextBox);
		this.connectParamsBox.Controls.Add(this.DataLabel);
		this.connectParamsBox.Controls.Add(this.portNumeric);
		this.connectParamsBox.Controls.Add(this.portLabel);
		this.connectParamsBox.Controls.Add(this.HostTextBox);
		this.connectParamsBox.Controls.Add(this.HostLabel);
		this.connectParamsBox.Controls.Add(this.serverPathBrowseButton);
		this.connectParamsBox.Controls.Add(this.serverPathTextBox);
		this.connectParamsBox.Controls.Add(this.serverPathLabel);
		this.connectParamsBox.Controls.Add(this.ForceGTXserverPathCheck);
		this.connectParamsBox.Controls.Add(this.useRunningServerRadio);
		this.connectParamsBox.Controls.Add(this.runServerRadio);
		this.connectParamsBox.Location = new System.Drawing.Point(8, 8);
		this.connectParamsBox.Name = "connectParamsBox";
		this.connectParamsBox.Size = new System.Drawing.Size(336, 196);
		this.connectParamsBox.TabIndex = 3;
		this.connectParamsBox.TabStop = false;
		this.connectParamsBox.Text = "Connection Parameters";
		// 
		// dataBrowse
		// 
		this.dataBrowse.Location = new System.Drawing.Point(269, 166);
		this.dataBrowse.Name = "dataBrowse";
		this.dataBrowse.Size = new System.Drawing.Size(24, 23);
		this.dataBrowse.TabIndex = 12;
		this.dataBrowse.Text = "...";
		this.dataBrowse.Click += new System.EventHandler(this.dataBrowse_Click);
		// 
		// dataTextBox
		// 
		this.dataTextBox.Location = new System.Drawing.Point(79, 167);
		this.dataTextBox.Name = "dataTextBox";
		this.dataTextBox.Size = new System.Drawing.Size(184, 20);
		this.dataTextBox.TabIndex = 11;
		this.dataTextBox.Text = "";
		// 
		// DataLabel
		// 
		this.DataLabel.Location = new System.Drawing.Point(16, 169);
		this.DataLabel.Name = "DataLabel";
		this.DataLabel.Size = new System.Drawing.Size(64, 16);
		this.DataLabel.TabIndex = 10;
		this.DataLabel.Text = "DATA Path";
		// 
		// portNumeric
		// 
		this.portNumeric.Location = new System.Drawing.Point(80, 142);
		this.portNumeric.Maximum = new System.Decimal(new int[] {
																															65535,
																															0,
																															0,
																															0});
		this.portNumeric.Minimum = new System.Decimal(new int[] {
																															1,
																															0,
																															0,
																															0});
		this.portNumeric.Name = "portNumeric";
		this.portNumeric.Size = new System.Drawing.Size(80, 20);
		this.portNumeric.TabIndex = 9;
		this.portNumeric.Value = new System.Decimal(new int[] {
																														1,
																														0,
																														0,
																														0});
		// 
		// portLabel
		// 
		this.portLabel.Location = new System.Drawing.Point(32, 144);
		this.portLabel.Name = "portLabel";
		this.portLabel.Size = new System.Drawing.Size(32, 16);
		this.portLabel.TabIndex = 8;
		this.portLabel.Text = "Port";
		// 
		// HostTextBox
		// 
		this.HostTextBox.Location = new System.Drawing.Point(80, 117);
		this.HostTextBox.Name = "HostTextBox";
		this.HostTextBox.Size = new System.Drawing.Size(184, 20);
		this.HostTextBox.TabIndex = 7;
		this.HostTextBox.Text = "localhost";
		// 
		// HostLabel
		// 
		this.HostLabel.Location = new System.Drawing.Point(32, 120);
		this.HostLabel.Name = "HostLabel";
		this.HostLabel.Size = new System.Drawing.Size(32, 16);
		this.HostLabel.TabIndex = 6;
		this.HostLabel.Text = "Host";
		// 
		// serverPathBrowseButton
		// 
		this.serverPathBrowseButton.Location = new System.Drawing.Point(294, 66);
		this.serverPathBrowseButton.Name = "serverPathBrowseButton";
		this.serverPathBrowseButton.Size = new System.Drawing.Size(24, 23);
		this.serverPathBrowseButton.TabIndex = 5;
		this.serverPathBrowseButton.Text = "...";
		this.serverPathBrowseButton.Click += new System.EventHandler(this.serverPathBrowseButton_Click);
		// 
		// serverPathTextBox
		// 
		this.serverPathTextBox.Location = new System.Drawing.Point(127, 68);
		this.serverPathTextBox.Name = "serverPathTextBox";
		this.serverPathTextBox.Size = new System.Drawing.Size(160, 20);
		this.serverPathTextBox.TabIndex = 4;
		this.serverPathTextBox.Text = "";
		// 
		// serverPathLabel
		// 
		this.serverPathLabel.Location = new System.Drawing.Point(40, 72);
		this.serverPathLabel.Name = "serverPathLabel";
		this.serverPathLabel.Size = new System.Drawing.Size(88, 16);
		this.serverPathLabel.TabIndex = 3;
		this.serverPathLabel.Text = "GTXserver Path";
		// 
		// ForceGTXserverPathCheck
		// 
		this.ForceGTXserverPathCheck.Location = new System.Drawing.Point(32, 48);
		this.ForceGTXserverPathCheck.Name = "ForceGTXserverPathCheck";
		this.ForceGTXserverPathCheck.Size = new System.Drawing.Size(138, 16);
		this.ForceGTXserverPathCheck.TabIndex = 2;
		this.ForceGTXserverPathCheck.Text = "Force GTXserver Path";
		// 
		// useRunningServerRadio
		// 
		this.useRunningServerRadio.Location = new System.Drawing.Point(16, 96);
		this.useRunningServerRadio.Name = "useRunningServerRadio";
		this.useRunningServerRadio.Size = new System.Drawing.Size(208, 16);
		this.useRunningServerRadio.TabIndex = 1;
		this.useRunningServerRadio.Text = "Use an Already Running GTXserver";
		// 
		// runServerRadio
		// 
		this.runServerRadio.Checked = true;
		this.runServerRadio.Location = new System.Drawing.Point(16, 24);
		this.runServerRadio.Name = "runServerRadio";
		this.runServerRadio.Size = new System.Drawing.Size(104, 16);
		this.runServerRadio.TabIndex = 0;
		this.runServerRadio.TabStop = true;
		this.runServerRadio.Text = "Run GTXserver";
		// 
		// infoTextBox
		// 
		this.infoTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
			| System.Windows.Forms.AnchorStyles.Left) 
			| System.Windows.Forms.AnchorStyles.Right)));
		this.infoTextBox.Location = new System.Drawing.Point(10, 490);
		this.infoTextBox.Name = "infoTextBox";
		this.infoTextBox.Size = new System.Drawing.Size(442, 78);
		this.infoTextBox.TabIndex = 4;
		this.infoTextBox.Text = "";
		// 
		// Browser
		// 
		this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
		this.ClientSize = new System.Drawing.Size(456, 571);
		this.Controls.Add(this.infoTextBox);
		this.Controls.Add(this.connectParamsBox);
		this.Controls.Add(this.Connect);
		this.Controls.Add(this.GTXTree);
		this.Name = "Browser";
		this.Text = "GTXserver C# Browser";
		this.connectParamsBox.ResumeLayout(false);
		((System.ComponentModel.ISupportInitialize)(this.portNumeric)).EndInit();
		this.ResumeLayout(false);

	}
	#endregion

	/// <summary>
	/// Application Entry Point
	/// </summary>
	[STAThread]
	static void Main() 
	{
		Application.Run(new Browser());
	}

	/// <summary>
	/// Retrieve study, dir, file and variable names a node and 
	/// select them in GTXserver.
	/// </summary>
	/// <param name="node">a (selected) node</param>
	/// <param name="study">correponding study name</param>
	/// <param name="directory">correponding directory name</param>
	/// <param name="file">correponding file name</param>
	/// <param name="variable">correponding variable name</param>
	public void SetFromNode(TreeNode node,
		out string study,
		out string directory,
		out string file,
		out string variable)
	{
		study = directory = file = variable = null;

		int level = (int)node.Tag;
		switch (level)
		{
			case 1:
				study     = node.Text.ToString();
				break;
			case 2:
				study     = node.Parent.Text.ToString();
				directory = node.Text.ToString();
				break;
			case 3:
				study     = node.Parent.Parent.Text.ToString();
				directory = node.Parent.Text.ToString();
				file      = node.Text.ToString();
				break;
			case 4:
				study     = node.Parent.Parent.Parent.Text.ToString();
				directory = node.Parent.Parent.Text.ToString();
				file      = node.Parent.Text.ToString();
				variable  = node.Text.ToString();
				break;
		}
		client.SetStudy(study);
		if (directory != null) 
		{
			client.SetDirectory(directory);
			if (file != null)
			{
				client.SetFile(file);
				if (variable!= null)
					client.SetVariable(variable);
			}
		}
	}

	/// <summary>
	/// Event Handler before expanding a node.
	/// It deletes the "None" node and lists real content.
	/// </summary>
	public void GTXTree_BeforeExpand(object sender,
		TreeViewCancelEventArgs e)
	{
		TreeNode node = e.Node;
		Cursor.Current = Cursors.WaitCursor;
		string study, directory, file, variable;
		SetFromNode(node, out study, out directory, out file, out variable);
		int level = (int)node.Tag;

		string[] subnodes;
		if (directory == null) 
			subnodes = client.GetDirectoryList().GetValues();
		else	
		{
			if (file == null)
				subnodes = client.GetFileList().GetValues();
			else
				subnodes = client.GetVariableList().GetValues();
		}

		GTXTree.BeginUpdate();
		node.Nodes.RemoveAt(0);
		for (int i=0; i<subnodes.Length; i++)
		{
			TreeNode tn = new TreeNode(subnodes[i]);
			if (level != 3)
				tn.Nodes.Add(new TreeNode("None"));
			tn.Tag = level+1;
			node.Nodes.Add(tn);
		}
		GTXTree.EndUpdate();
		Cursor.Current = System.Windows.Forms.Cursors.Default;
	}

	/// <summary>
	/// Event Handler after collapsing a node.
	/// Remove contents and recreate a "None" node (to keep the + sign)
	/// </summary>
	public void GTXTree_AfterCollapse(object sender,
		TreeViewEventArgs e)
	{
		TreeNode node = e.Node;
		GTXTree.BeginUpdate();
		node.Nodes.Clear();
		node.Nodes.Add(new TreeNode("None"));
		GTXTree.EndUpdate();
	}

	/// <summary>
	/// Connect Button Click: Connects to the GTXserver
	/// </summary>
	private void Connect_Click(object sender, System.EventArgs e)
	{
		ArrayList GTXTreeArray = new ArrayList();
		ushort port = (ushort)this.portNumeric.Value;
		string host = HostTextBox.Text;
		if (runServerRadio.Checked)
		{
			string server_path = null;
			if (ForceGTXserverPathCheck.Checked)
				server_path	= serverPathTextBox.Text;
			port = client.RunGTXserver(0);
			host = "localhost";
		}
		client.Connect(host, port, dataTextBox.Text);
		RebuildTree();
	}

	/// <summary>
	/// Rebuilds tree nodes by deleting all nodes, asking for study list
	/// and create a node for each study
	/// </summary>
	private void RebuildTree()
	{
		string[] studies = client.GetStudyList().GetValues();
		GTXTree.BeforeExpand += new TreeViewCancelEventHandler(GTXTree_BeforeExpand);
		GTXTree.AfterCollapse += new TreeViewEventHandler(GTXTree_AfterCollapse);
		Cursor.Current = Cursors.WaitCursor;
		GTXTree.BeginUpdate();
		// Clear the TreeView each time the method is called.
		GTXTree.Nodes.Clear();

		for (int i=0; i<studies.Length; i++)
		{
			TreeNode tn = new TreeNode(studies[i]);
			tn.Nodes.Add(new TreeNode("None"));
			tn.Tag = 1;
			GTXTree.Nodes.Add(tn);
		}
		GTXTree.EndUpdate();
		Cursor.Current = System.Windows.Forms.Cursors.Default;
	}

	/// <summary>
	/// TreeView Context Menu: enable/disable items according to the selection
	/// </summary>
	private void contextMenu1_Popup(object sender, System.EventArgs e)
	{
		// Desactivate all menu entries
		for (int i = 0; i < contextMenu1.MenuItems.Count; i++)
			contextMenu1.MenuItems[i].Enabled = false;

		TreeNode tn = GTXTree.SelectedNode;
		if (tn == null) return;
		switch ((int)tn.Tag)
		{
			case 3: // File -> Info
				contextMenu1.MenuItems[0].Enabled = true;
				break;
			case 4: // Variable -> All
				for (int i = 0; i < contextMenu1.MenuItems.Count; i++)
					contextMenu1.MenuItems[i].Enabled = true;
				break;
		}
	}
	
	/// <summary>
	/// Click callback from the Info Menu Item
	/// </summary>
	/// <param name="sender">sender object</param>
	/// <param name="e">click event</param>
	private void InfoMenuItem_Click(object sender, System.EventArgs e)
	{
		TreeNode tn = GTXTree.SelectedNode;
		if (tn == null) return;
		string study, directory, file, variable;
		SetFromNode(tn, out study, out directory, out file, out variable);
		infoTextBox.Text = null;
		if (variable == null && file != null)
			infoTextBox.Text = InfoDump.FileInfo(client,0);
		else if (variable != null)
			infoTextBox.Text = InfoDump.VariableInfo(client,false,0);
	}

	/// <summary>
	/// Click callback from the Statistics Menu Item
	/// </summary>
	/// <param name="sender">sender object</param>
	/// <param name="e">click event</param>
	private void StatMenuItem_Click(object sender, System.EventArgs e)
	{
		TreeNode tn = GTXTree.SelectedNode;
		if (tn == null) return;
		string study, directory, file, variable;
		SetFromNode(tn, out study, out directory, out file, out variable);
		infoTextBox.Text = null;
		if (variable != null)
			infoTextBox.Text = InfoDump.VariableInfo(client,true,0);
	}
		
	/// <summary>
	/// TreeView Mouse Down Event to fix a strange behaviour of the normal contextMenu.
	///	where it is not possible to know the highlighted node, so force it.
	/// </summary>
	private void GTXTree_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
	{
		infoTextBox.Text = null;
		if (e.Button != MouseButtons.Right) return;
		TreeNode tn = GTXTree.GetNodeAt(e.X, e.Y);
		GTXTree.SelectedNode = tn;
		contextMenu1.Show(GTXTree, new Point(e.X, e.Y));
	}

	/// <summary>
	/// Click callback from the Server Path Browse Button
	/// </summary>
	private void serverPathBrowseButton_Click(object sender, System.EventArgs e)
	{
		OpenFileDialog openFileDialog1 = new OpenFileDialog();
		openFileDialog1.Filter = "GTXserver executable|GTXserver*.exe|All files (*.*)|*.*";
		openFileDialog1.FilterIndex = 1;
		if (openFileDialog1.ShowDialog() == DialogResult.OK)
			serverPathTextBox.Text = openFileDialog1.FileName;
	}

	/// <summary>
	/// Click callback from the Data Path Browse Button
	/// </summary>
	private void dataBrowse_Click(object sender, System.EventArgs e)
	{
		FolderBrowserDialog folderBrowserDialog1 = new FolderBrowserDialog();
		folderBrowserDialog1.ShowNewFolderButton = false;
		if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
			dataTextBox.Text = folderBrowserDialog1.SelectedPath;
	}
}
