/*****************************************************************************

            Copyright (c)2008 Geovariances, Avon, France.

    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.

    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).

            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE

             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr

                        All Rights Reserved

*****************************************************************************/

using System;
using System.IO;
using com.geovariances.gtxclient;
using System.Reflection;
using System.Runtime.CompilerServices;

[assembly: AssemblyTitle("Dump.C#")]
[assembly: AssemblyDescription("C# Dump client for GTXserver")]

/// <summary>
/// C# Dump Client for GTXClient.
/// </summary>
class Dump
{
  /// <summary>
  /// Method reporting the possible command line arguments
  /// </summary>
  /// <param name="help">if true, give complete argument documentation</param>
  public static void Usage(bool help)
  {
    Console.WriteLine("Usage: Dump [-help]");
    Console.WriteLine("            [-host hostname] [-port port_number]");
    Console.WriteLine("            [-path data_path]");

    if (help)
    {
      Console.WriteLine(" -help            : Print this message.");
      Console.WriteLine(" -debug           : Print client/server messages.");
      Console.WriteLine(" -host hostname   : Connect to a Server running on hostname.");
      Console.WriteLine(" -port port_number: Port used by the already running server on given host");
      Console.WriteLine(" -path data_path  : Initialize connection with given data_path.");
      Console.WriteLine("The default is to run a new server on a random port.");
      Console.WriteLine("If -host or -port is specified, a server must have been started first on the given host/port");
    }
  }
	
  /// <summary>
  /// Point d'entre principal de l'application.
  /// </summary>
  [STAThread]
  static void Main(string[] args)
  {
    GTXClient client = new GTXClient();

    bool run_server = true;
    string host = "localhost";
    string path = "";
    ushort port = 0;
    for (int i = 0; i < args.Length; i++)
    {
      switch (args[i])
      {
        case "-help": Usage(true); return;
        case "-debug": client.SetDebugMode(true); return;
        case "-host": if (i == args.Length-1) { Usage(false); return; }
          run_server = false;
          host = args[++i];
          break;
        case "-port": if (i == args.Length-1) { Usage(false); return; }
          run_server = false;
          port = ushort.Parse(args[++i]);
          break;
        case "-path":  if (i == args.Length-1) { Usage(false); return; }
          path = args[++i];
          break;
        default:
          Usage(false);
          return;
      }
    }

    try
    {
      if (run_server)
      {
        port = client.RunGTXserver(0);
        host = "localhost";
      }
      else if (port == 0)
        port = client.GetDefaultPort();
      client.Connect(host, port, path);

      String[] studies = client.GetStudyList().GetValues();
      for (int i = 0; i < studies.Length; i++)
      {
        Console.WriteLine("\nStudy: " + studies[i]);
        client.SetStudy(studies[i]);

        String[] dirs = client.GetDirectoryList().GetValues();
        for (int j = 0; j < dirs.Length; j++)
        {
          Console.WriteLine("\n   Directory: " + dirs[j]);
          client.SetDirectory(dirs[j]);

          String[] files = client.GetFileList().GetValues();
          for (int k = 0; k < files.Length; k++)
          {
            Console.WriteLine("\n      File: " + files[k]);
            client.SetFile(files[k]);

            string buffer = InfoDump.FileInfo(client, 9);
            Console.WriteLine(buffer);

            String[] variables = client.GetVariableList().GetValues();
            for (int l = 0; l < variables.Length; l++)
            {
              Console.WriteLine("\n         Variable: " + variables[l]);
              client.SetVariable(variables[l]);
              buffer = InfoDump.VariableInfo(client, true, 11);
              Console.WriteLine(buffer);
            }
          }
        }
      }
      client.Disconnect();
    }
    catch (GTXError e)
    {
      // Do not use Console.Error because it seems not to output the messages sometimes.
      Console.WriteLine("Error with GTXserver communication:");
      Console.WriteLine(e.Message);
    }
  }
}
