/*****************************************************************************

            Copyright (c)94-98 Geovariances, Avon, France.

    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.

    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).

            Geovariances
            38, Avenue Franklin Roosevelt
            77210 Avon, FRANCE

             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr

                        All Rights Reserved

*****************************************************************************/

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

import com.geovariances.gtxclient.*;

/**
 * This sample code gives you an example of a graphic user interface for
 * Isatis file system browser.
 *
 * @author   Geovariances
 * @version  $Revision: 12707 $ $Date: 2008-07-03 09:53:55 +0200 (Thu, 03 Jul 2008) $
 */

public class browser extends Frame {

  public Panel pConnect;
  public TextField tfDataPath;
  public TextField tfHost;
  public TextField tfPort;

  public Panel pTop;
  public CardLayout pTopLayout;

  public Panel pData;
  public Label label1;
  public Label label2;
  public java.awt.Checkbox runBox;
  public java.awt.List liData;
  public java.awt.List liIndices;
  public Button btInfo;
  public Button btStats;
  public Button btDump;
  public Button btSelect;
  public TextArea taInfo;

  public Panel pStatus;
  public TextField tfStatus;
  public Button btConnect;
  public Button btExit;

  // The GTXClient connection
  public GTXClient client = null;

  public String current_study;
  public String current_dir;
  public String current_file;
  public String current_var;
  public String current_sel = "";
  public int current_indice;

  public int mode = 0;
  public static final int MODE_INIT  = 0;
  public static final int MODE_STUDY = 1;
  public static final int MODE_DIR   = 2;
  public static final int MODE_FILE  = 3;
  public static final int MODE_VAR   = 4;

  public static void main(String[] args)
  {
    new browser();
  }

  browser()
  {
    super("GTX filesystem Browser");

    // Panel for top (connect / data)
    pTopLayout = new CardLayout();
    pTop = new Panel(pTopLayout);
    add(pTop);

    // Panel for connect
    pConnect = new Panel(new GridBagLayout());
    pTop.add(pConnect, "Connect");

    makeObject(pConnect, new Label("Data path: ", Label.RIGHT), 0, 0, 1, 1, 0.0, 0.0);

    tfDataPath = new TextField(50);
    tfDataPath.setText("");
    makeObject(pConnect, tfDataPath,  1, 0, 1, 1, 1.0, 0.0);

    runBox = new Checkbox("Run GTXserver");
    runBox.setState(true);
    makeObject(pConnect, runBox, 1, 1, 1, 1, 0.0, 0.0);
    runBox.addItemListener(new listItemListener());

    makeObject(pConnect, new Label("Host: ", Label.RIGHT), 0, 2, 1, 1, 0.0, 0.0);

    tfHost = new TextField(50);
    tfHost.setText("localhost");
    makeObject(pConnect, tfHost, 1, 2, 1, 1, 1.0, 0.0);

    makeObject(pConnect, new Label("Port: ", Label.RIGHT), 0, 3, 1, 1, 0.0, 0.0);

    tfPort = new TextField(50);
    tfPort.setText("5500");
    makeObject(pConnect, tfPort, 1, 3, 1, 1, 1.0, 0.0);

    // Panel for data
    pData = new Panel(new GridBagLayout());
    pTop.add(pData, "Data");

    label1 = new Label("");
    makeObject(pData, label1, 0, 0, 1, 1, 0.0, 0.0);

    label2 = new Label("Studies list:");
    makeObject(pData, label2, 0, 1, 1, 1, 0.0, 0.0);

    liData = new java.awt.List(10);
    liData.addActionListener(new ListDataListener());
    liData.addItemListener(new listItemListener());
    makeObject(pData, liData, 0, 2, 1, 1, 0.7, 0.0);

    liIndices = new java.awt.List(10);
    liData.addItemListener(new listItemListener());
    makeObject(pData, liIndices, 1, 2, 1, 1, 0.3, 0.0);

    Panel p = new Panel(new GridLayout(4, 0, 10, 10));
    makeObject(pData, p, 0, 3, 1, 1, 0.0, 0.0);

    btInfo = new Button("Information");
    btInfo.addActionListener(new InformationDataListener());
    btInfo.setEnabled(false);
    p.add(btInfo);

    btStats = new Button("Statistics");
    btStats.addActionListener(new StatisticsDataListener());
    btStats.setEnabled(false);
    p.add(btStats);

    btDump = new Button("Dump");
    btDump.addActionListener(new DumpDataListener());
    btDump.setEnabled(false);
    p.add(btDump);

    btSelect = new Button("(Un)set Selection");
    btSelect.addActionListener(new UnsetSelectionDataListener());
    btSelect.setEnabled(false);
    p.add(btSelect);

    taInfo = new TextArea("", 20, 20);
    makeObject(pData, taInfo, 1, 3, 1, 1, 0.0, 0.0);

    // Panel for status
    pStatus = new Panel(new GridBagLayout());
    add(pStatus, BorderLayout.SOUTH);

    tfStatus = new TextField(80);
    tfStatus.setText("Disconnected...");
    tfStatus.setEditable(false);
    makeObject(pStatus, tfStatus, 0, 0, 5, 1, 0.0, 0.0);

    btConnect = new Button("  Connect  ");
    btConnect.addActionListener(new ConnectListener());
    makeObject(pStatus, btConnect, 0, 1, 1, 1, 0.0, 0.0);

    makeObject(pStatus, new Label(" ", Label.CENTER), 1, 1, 3, 1, 0.5, 0.0);

    btExit = new Button("Exit");
    makeObject(pStatus, btExit, 4, 1, 1, 1, 0.0, 0.0);
    btExit.addActionListener(new ExitListener());

    pack();
    setVisible(true);
  }

  // A convenient method to place interface objects
  public void makeObject(Container cont, Object arg, int x, int y, int w, int h,
                         double weightx, double weighty)
  {
    GridBagLayout gbl = (GridBagLayout)cont.getLayout();
    GridBagConstraints c = new GridBagConstraints();

    c.fill = GridBagConstraints.BOTH;
    c.gridx = x;
    c.gridy = y;
    c.gridwidth = w;
    c.gridheight = h;
    c.weightx = weightx;
    c.weighty = weighty;
    cont.add((Component)arg);
    gbl.setConstraints((Component)arg, c);
  }

  // Inner class definitions for Connect button listener
  class ConnectListener implements ActionListener {
    public void actionPerformed(ActionEvent evt)
    {
      if (mode == MODE_INIT)
      {
        client = new GTXClient();
        client.SetDebugMode(true);
        try
        {
          // Open a session with the GTXserver

          // Example with running a GTXserver
          if (runBox.getState())
          {
            int nport = client.RunGTXserver(0);
            client.Connect("localhost", nport, tfDataPath.getText());
          }
          else
          {
            // Connect to Given Information
            client.Connect(tfHost.getText(),
                           Integer.parseInt(tfPort.getText()),
                           tfDataPath.getText());
          }
          btConnect.setLabel("Connect");
          btConnect.setLabel("Disconnect");
          tfStatus.setText("Connected...");

          pTopLayout.show(pTop, "Data");

          // Get the list of studies and display it in the List
          liData.removeAll();
          liIndices.removeAll();
          String studies[] = client.GetStudyList().GetValues();
          for(int i=0; i<studies.length; i++) liData.add(studies[i]);
          label1.setText("");
          label2.setText("Study list:");

          mode = MODE_STUDY;
        }
        catch (GTXError e)
        {
          tfStatus.setText(e.getMessage());
        }
      }
      else
      {
        try
        {
          client.Disconnect();
          btConnect.setLabel("Connect");
          tfStatus.setText("Disconnected...");

          pTopLayout.show(pTop, "Connect");
          mode = MODE_INIT;
        }
        catch (GTXError e)
        {
          tfStatus.setText(e.getMessage());
        }
      }
    }
  }

  // Inner class definitions for Exit button listener
  class ExitListener implements ActionListener {
    public void actionPerformed(ActionEvent evt)
    {
      // Disconnect from the server if needed
      if (mode != MODE_INIT)
      {
        try
        {
          client.Disconnect();
        }
        catch (GTXError e)
        {
          tfStatus.setText(e.getMessage());
        }
      }
      System.exit(0);
    }
  }

  // Inner class definitions for Information button listener
  class InformationDataListener implements ActionListener {
    public void actionPerformed(ActionEvent evt)
    {
      try
      {
        // Information available for file or variable
        if (mode < MODE_FILE) return;

        switch(mode)
        {
          case MODE_FILE:
          {
            if (liData.getSelectedItem() == null || liData.getSelectedItem() == "..") return;

            current_file = liData.getSelectedItem();
            client.SetFile(current_file);
            GTXFileInfo finfo = client.GetFileInfo();
            String info = "";
            info += "File: " + current_file + "\n";


            /*Modif*/

            switch (finfo.GetFileType())
            {
              case FILE_TYPE_POINTS:         info += "Type:Points";  break;
              case FILE_TYPE_GRAVITY_LINES:  info += "Type:Gravity_Lines";   break;
              case FILE_TYPE_CORE_LINES:     info += "Type:Core_Lines";   break;
              case FILE_TYPE_GRID:           info += "Type:Grid";    break;
              default:                       info += "Type:Unknown"; break;
            }
            /*EndModif*/

            info += "Dimension: " + finfo.GetDimension() + "D\n";
            info += "Number of samples: " + finfo.GetSampleNumber() + "\n";
            if (finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_CORE_LINES ||
                finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_GRAVITY_LINES )
            {
              info += "Number of lines: " + finfo.GetItemNumber() + "\n";
            }
            else if (finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_GRID)
            {
              if (finfo.GetDimension() == 2)
              {
                info += "Number of nodes: (" + finfo.GetGridNX() + "," + finfo.GetGridNY() + ")\n";
                info += "Origin         : (" + finfo.GetGridX0() + "," + finfo.GetGridY0() + ")\n";
                info += "Mesh dimensions: (" + finfo.GetGridDX() + "," + finfo.GetGridDY() + ")\n";
                if (finfo.GetGridRotatedFlag() == true)
                  info += "Rotation angle: " + finfo.GetGridAngleAroundZ() +"\n";
                else
                  info += "No rotation\n";
              }
              else
              {
                info += "Number of nodes: (" + finfo.GetGridNX() + "," + finfo.GetGridNY() + "," + finfo.GetGridNZ() + ")\n";
                info += "Origin         : (" + finfo.GetGridX0() + "," + finfo.GetGridY0() + "," + finfo.GetGridZ0() + ")\n";
                info += "Mesh dimensions: (" + finfo.GetGridDX() + "," + finfo.GetGridDY() + "," + finfo.GetGridDZ() + ")\n";
                if (finfo.GetGridRotatedFlag() == true)
                {
                  info += "Rotation angle around Z: " + finfo.GetGridAngleAroundZ() + "\n";
                  info += "Rotation angle around Y: " + finfo.GetGridAngleAroundY() + "\n";
                  info += "Rotation angle around X: " + finfo.GetGridAngleAroundX() + "\n";
                }
                else
                  info += "No rotation\n";
              } // end of 3D
            } // end of if grid

            String comment = client.GetFileComment();
            if (comment.length() != 0)
              System.out.println("           Comment: " + comment);

            // special variables information
            info += "Sample Number variable: " + finfo.GetSampleNumberVariableName() + "\n";
            if (finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_GRAVITY_LINES ||
                finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_CORE_LINES)
            {
              info += "Line Number variable: " +finfo.GetLineNumberVariableName() + "\n";
              info += "Relative Number variable: " + finfo.GetRelativeNumberVariableName() + "\n";
            }
            info += "X Gravity Center variable: " + finfo.GetXCoordinateVariableName() + "\n";
            info += "Y Gravity Center variable: " + finfo.GetYCoordinateVariableName() + "\n";
            if (finfo.GetDimension() == 3)
              info += "Z Gravity Center variable: " + finfo.GetZCoordinateVariableName() + "\n";

            if (finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_CORE_LINES)
            {
              info += "X Core Begin variable: " + finfo.GetXCoreBeginVariableName() + "\n";
              info += "Y Core Begin variable: " + finfo.GetYCoreBeginVariableName() + "\n";
              if (finfo.GetDimension() == 3)                             
                info += "Z Core Begin variable: " + finfo.GetZCoreBeginVariableName() + "\n";
              
              info += "X Core End variable: " + finfo.GetXCoreEndVariableName() + "\n";
              info += "Y Core End variable: " + finfo.GetYCoreEndVariableName() + "\n";
              if (finfo.GetDimension() == 3)                             
                info += "Z Core End variable: " + finfo.GetZCoreEndVariableName() + "\n";
            }
            

            if (finfo.GetFaultedFlag() )
            {
              GTXFaultInfo fault_info = finfo.GetFaultInfo();
              info += "\nFaulted File:\n";
              info += "2D Faults: " +
                (fault_info.GetFaults2DFlag() ? "Y\n": "N\n");
              info += "Auxiliary Variable Used: " +
                      (fault_info.GetAuxiliaryVarUsedFlag() ? "Y\n": "N\n");
              info += "Number of faults: " +
                fault_info.GetFaultsNumber() + "\n";
              info += "Number of segments: " +
                fault_info.GetSegmentsNumber() + "\n";
              info += "Minimum Used Priority: " +
                fault_info.GetMinimumPriority() + "\n";
              info += "Maximum Used Priority: " +
                      fault_info.GetMaximumPriority() + "\n";
              info += "Authorized Priority: " +
                fault_info.GetAuthorizedPriority() + "\n";

             
            }
            taInfo.setText(info);
          }
          break;

          case MODE_VAR:
          {
            if (liData.getSelectedItem() == null || liData.getSelectedItem() == "..") return;

            current_var = liData.getSelectedItem();
            client.SetVariable(current_var);
            GTXVariableInfo vinfo = client.GetVariableInfo();
            String info = "";
            info += "Variable: " + current_var + "\n";
            switch (vinfo.GetVariableType())
            {
              case VAR_TYPE_FLOAT: info += "Float";            break;
              case VAR_TYPE_CHAR:  info += "Float";            break;
              case VAR_TYPE_XG:    info += "X Gravity Center"; break;
              case VAR_TYPE_YG:    info += "Y Gravity Center"; break;
              case VAR_TYPE_ZG:    info += "Z Gravity Center"; break;
              case VAR_TYPE_MACRO: info += "Macro"; System.in.read(); break;
              default:               info += "Unknown"; break;
            }
            
            if (vinfo.GetLengthFlag())
              info += " (Length)";
            info += "\n";
            
            if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_CHAR)
              info += "Alpha length: " + vinfo.GetAlphaLength() + "\n";
            else
            {
          if (vinfo.GetBitLength()==1)
                info += "Precision: " + vinfo.GetBitLength() + " bit (selection)\n";
              else
                info += "Precision: " + vinfo.GetBitLength() + "bits\n";
              	      if (! vinfo.GetUnit().equals(vinfo.GetUnitSymbol()))
                              info += "Unit: " + vinfo.GetUnit() + "\n";
                              else
                              info += "Unit: " + vinfo.GetUnitSymbol() + " (Factor "+ vinfo.GetUnit() +")\n";
            }
            String comment = client.GetVariableComment();
            if (comment != "")
              info += "Comment: " + comment + "\n";
        if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_MACRO)
        {
          int indices[] = client.GetMacroIndices().GetValues();
          if (indices.length != 0)
          {
        info += "Indices:\n";
                int i;
        for(i=0; i<((indices.length>10) ? 10 : indices.length); i++)
          info += " " + indices[i];
                if( i == 10)
          info += " ...\n";
        else
          info += "\n";
              }
            }
            taInfo.setText(info);
          }
          break;
        }
      }
      catch (IOException e)
      {
        System.err.println("IO Exception: " + e.getMessage());
        e.printStackTrace();
        System.exit(1);
      }

      catch (GTXError e)
      {
        tfStatus.setText(e.getMessage());
      }
    }
  }

  class StatisticsDataListener implements ActionListener {
    public void actionPerformed(ActionEvent evt)
    {
      try
      {
        if (liData.getSelectedItem() != null || liData.getSelectedItem() != "..")
        {
          current_var = liData.getSelectedItem();
          GTXFileInfo finfo = client.GetFileInfo();
          GTXVariableInfo vinfo = client.GetVariableInfo();
          GTXCharData cdata = null;
          GTXDoubleData fdata = null;
          int n_kept, n_def;

          if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_MACRO)
          {
            current_indice = Integer.parseInt(liIndices.getSelectedItem());
            System.out.println("current_indice = " + current_indice + "\n");
            client.SetIndice(current_indice);
          }

          String info = "";
          info += "Variable: " + current_var + "\n";

          tfStatus.setText("Reading variable...");
          if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_CHAR)
          {
            cdata = client.ReadCharVariable(true);
            n_kept = cdata.GetCount();
          }
          else
          {
            fdata = client.ReadDoubleVariable(true);
            n_kept = fdata.GetCount();
          }

          if (finfo.GetSampleNumber() != n_kept)
            info += "Total number of samples: " + n_kept + "/" + finfo.GetSampleNumber() + "\n";
          else
            info += "Total number of samples: " + finfo.GetSampleNumber() + "\n";

          n_def = 0;
          if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_CHAR)
          {
            for (int i = 0; i < n_kept; i++)
              if (cdata.GetValue(i) != cdata.GetUndefinedValue()) n_def++;
            info += "Number of defined samples: " + n_def;
          }
          else if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_FLOAT &&
                   vinfo.GetBitLength() == 1)
          {
            for (int i = 0; i < n_kept; i++)
              if (fdata.GetValue(i) == 1) n_def++;
            info += "Number of defined samples: " + n_def + "\n";
          }
          else
          {
            double min = 1.e300;
            double max = -1.e300;
            double mean = 0.;

            for (int i = 0; i < n_kept; i++)
              if (fdata.GetValue(i) != fdata.GetUndefinedValue())
              {
                n_def++;
                mean += fdata.GetValue(i);
                min = ((fdata.GetValue(i) < min) ? fdata.GetValue(i) : min);
                max = ((fdata.GetValue(i) > max) ? fdata.GetValue(i) : max);
              }
            info += "Number of defined samples: " + n_def + "\n";
            if (n_def != 0)
            {
              mean /= n_def;
              info += "Minimum value: " + min + "\n";
              info += "Maximum value: " + max + "\n";
              info += "Mean value: " + mean + "\n";
            }
          }
          taInfo.setText(info);
        }
      }
        catch (GTXError e)
        {
          tfStatus.setText(e.getMessage());
        }
    }
  }

  class DumpDataListener implements ActionListener {
    public void actionPerformed(ActionEvent evt)
    {
      try
      {
        if (liData.getSelectedItem() == null || liData.getSelectedItem() != "..")
        {
          current_var = liData.getSelectedItem();
          client.SetVariable(current_var);

          GTXVariableInfo vinfo = client.GetVariableInfo();
          if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_MACRO)
          {
            current_indice = Integer.parseInt(liIndices.getSelectedItem());
            client.SetIndice(current_indice);
          }

          GTXCharData cdata = null;
          GTXDoubleData  fdata = null;
          int n_kept = 0;



          if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_CHAR)
          {
            cdata = client.ReadCharVariable(true);
            n_kept = cdata.GetCount();
          }
          else
          {
            fdata = client.ReadDoubleVariable(true);
            n_kept = fdata.GetCount();
          }

          tfStatus.setText("Dumping variable...");

          System.out.println("# Study: " + current_study);
          System.out.println("# Directory: " + current_dir);
          System.out.println("# Selection: " + current_sel);
          System.out.println("# Variable: " + current_var);
          if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_MACRO)
            System.out.println("# Macro Indice: " + current_indice);
          if (vinfo.GetImplicitFlag())
            System.out.println("# Unit: " + vinfo.GetUnit());
          System.out.println("# Number of Samples: " + n_kept);
          if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_CHAR)
            for(int i=0; i<n_kept; i++)
              System.out.println(cdata.GetValue(i));
          else
            for(int i=0; i<n_kept; i++)
              System.out.println(fdata.GetValue(i));
        }
      }
        catch (GTXError e)
        {
          tfStatus.setText(e.getMessage());
        }
    }
  }

  class UnsetSelectionDataListener implements ActionListener {
    public void actionPerformed(ActionEvent evt)
    {
      try
      {
        if (current_sel.equals(""))
        {
          if (liData.getSelectedItem() != null && liData.getSelectedItem() != "..")
          {
            current_sel = liData.getSelectedItem();
            client.SetSelection(current_sel);
            tfStatus.setText("Selection " + current_sel + " set");
            label1.setText(current_study + ":" + current_dir + "/" + current_file + "/" + current_sel);
          }
        }
        else
        {
          current_sel = "";
          client.SetSelection(current_sel);
          tfStatus.setText("Unsetting selection...");
          label1.setText(current_study + ":" + current_dir + "/" + current_file);
        }
      }
        catch (GTXError e)
        {
          tfStatus.setText(e.getMessage());
        }
    }
  }

  class listItemListener implements ItemListener {
    public void itemStateChanged(ItemEvent evt)
    {
      if (evt.getSource() == liData)
      {
        if (evt.getStateChange() == ItemEvent.SELECTED)
        {
          try
          {
            switch(mode)
            {
              case MODE_VAR:
              {
                if (liData.getSelectedItem() != null && liData.getSelectedItem() != "..")
                {
                  client.SetVariable(liData.getSelectedItem());
                  GTXVariableInfo vinfo = client.GetVariableInfo();
                  if( vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_MACRO)
                  {
                    int indices[] = client.GetMacroIndices().GetValues();
                    liIndices.removeAll();
                    for(int i=0; i<indices.length; i++) liIndices.add(Integer.toString(indices[i]));
                  }
                }
              }
              break;
            }
          }
          catch (GTXError e)
          {
            tfStatus.setText(e.getMessage());
          }

        }
      }
    }
  }

  class ListDataListener implements ActionListener {
    public void actionPerformed(ActionEvent evt)
    {
      try
      {
        switch(mode)
        {
          case MODE_STUDY:
            current_study = liData.getSelectedItem();
            setDirList();
            break;

          case MODE_DIR:
            if (liData.getSelectedItem() == "..")
            {
              setStudyList();
              btInfo.setEnabled(false);
            }
            else
            {
              current_dir = liData.getSelectedItem();
              setFileList();
              btInfo.setEnabled(true);
            }
            break;

          case MODE_FILE:
            if (liData.getSelectedItem() == "..")
            {
              setDirList();
              btStats.setEnabled(false);
              btDump.setEnabled(false);
              btSelect.setEnabled(false);
            }
            else
            {
              current_file = liData.getSelectedItem();
              setVarList();
              btStats.setEnabled(true);
              btDump.setEnabled(true);
              btSelect.setEnabled(true);
            }
            break;

          case MODE_VAR:
            if (liData.getSelectedItem() == "..")
            {
              setFileList();
              btStats.setEnabled(false);
              btDump.setEnabled(false);
              btSelect.setEnabled(false);
            }

        }
      }
        catch (GTXError e)
        {
          tfStatus.setText(e.getMessage());
        }
    }
  }

  private void setStudyList() throws GTXError
  {
    liData.removeAll();
    liIndices.removeAll();

    String studies[] = client.GetStudyList().GetValues();
    for(int i=0; i<studies.length; i++) liData.add(studies[i]);

    label1.setText("");
    label2.setText("Study list:");

    mode = MODE_STUDY;
  }

  private void setDirList() throws GTXError
  {
    liData.removeAll();
    liIndices.removeAll();

    client.SetStudy(current_study);
    String dirs[] = client.GetDirectoryList().GetValues();
    liData.add("..");
    for(int i=0; i<dirs.length; i++) liData.add(dirs[i]);

    label1.setText(current_study);
    label2.setText("Directory List:");

    tfStatus.setText("Study " + current_study + " set");

    mode = MODE_DIR;
  }

  private void setFileList() throws GTXError
  {
    liData.removeAll();
    liIndices.removeAll();

    client.SetDirectory(current_dir);
    String files[] = client.GetFileList().GetValues();
    liData.add("..");
    for(int i=0; i<files.length; i++) liData.add(files[i]);

    label1.setText(current_study + ":" + current_dir);
    label2.setText("File List:");

    tfStatus.setText("Directory " + current_dir + " set");

    mode = MODE_FILE;
  }

  private void setVarList() throws GTXError
  {
    liData.removeAll();
    liIndices.removeAll();

    client.SetFile(current_file);
    String vars[] = client.GetVariableList().GetValues();
    liData.add("..");
    for(int i=0; i<vars.length; i++) liData.add(vars[i]);

    label1.setText(current_study + ":" + current_dir + "/" + current_file);
    label2.setText("Variable List:");

    mode = MODE_VAR;
  }

}
