/*****************************************************************************

            Copyright (c)2005 Geovariances, Avon, France.

    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.

    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).

            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE

             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr

                        All Rights Reserved

*****************************************************************************/

import java.io.*;

import com.geovariances.gtxclient.*;

class dump {

  public static void usage(boolean help)
  {
    System.err.println("Usage: Dump [-help]");
    System.err.println("            [-host hostname] [-port port_number]");
    System.err.println("            [-path data_path]");
    if (help)
    {
      System.err.println(" -debug           : Print client/server messages.");
      System.err.println(" -host hostname   : Connect to a Server running on hostname.");
      System.err.println(" -port port_number: Port used by the already running server on given host");
      System.err.println(" -path data_path  : Initialize connection with given data_path.");
      System.err.println("The default is to run a new server on a random port.");
      System.err.println("If -host or -port is specified, a server must have been started first on the given host/port");
      System.exit(1);
    }
  }

  public static void main(String[] args) throws IOException
  {
    GTXClient client = new GTXClient();

    boolean run_server = true;
    String host = "localhost";
    String path = "";
    int port = 0;
    for (int i = 0; i < args.length; i++)
    {
      if (args[i].equals("-help")) { usage(true); return; }
      else if (args[i].equals("-debug")) { client.SetDebugMode(true); return; }
      else if (args[i].equals("-host")) {
        if (i == args.length-1) { usage(false); return; }
        run_server = false;
        host = args[++i];
      }
      else if (args[i].equals("-port")) {
        if (i == args.length-1) { usage(false); return; }
        run_server = false;
        port = Integer.parseInt(args[++i]);
      }
      else if (args[i].equals("-path")) {
        if (i == args.length-1) { usage(false); return; }
        path = args[++i];
      }
      else {
        usage(false);
        return;
      }
    }

    if (run_server)
    {
      port = client.RunGTXserver(0);
      host = "localhost";
    }
    else if (port == 0)
      port = client.GetDefaultPort();
    client.Connect(host, port, path);

    String[] studies = client.GetStudyList().GetValues();
    for(int i=0; i<studies.length; i++)
    {
      System.out.println("\nStudy: " + studies[i]);
      client.SetStudy(studies[i]);

      String[] dirs = client.GetDirectoryList().GetValues();
      for(int j=0; j<dirs.length; j++)
      {
        System.out.println("\n   Directory: " + dirs[j]);
        client.SetDirectory(dirs[j]);

        try {
          String[] files = client.GetFileList().GetValues();
          for(int k=0; k<files.length; k++)
          {
            System.out.println("\n      File: " + files[k]);
            client.SetFile(files[k]);

            GTXFileInfo finfo = client.GetFileInfo();
            String type;
            switch (finfo.GetFileType())
            {
              case FILE_TYPE_POINTS:        type = "Points";  break;
              case FILE_TYPE_CORE_LINES:    type = "Core_Lines";   break;
              case FILE_TYPE_GRAVITY_LINES: type = "Gravity_Lines";   break;
              case FILE_TYPE_GRID:          type = "Grid";    break;
              default:                      type = "Unknown"; break;
            }
            System.out.println("             " + type + " File");
            System.out.println("             Dimension = " + finfo.GetDimension() + "D");
            System.out.println("             Number of samples = " + finfo.GetSampleNumber());
            if (finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_GRAVITY_LINES ||
                finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_GRAVITY_LINES)
            {
              System.out.println("             Number of lines = " + finfo.GetItemNumber());
            }
            else if (finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_GRID)
            {
              if (finfo.GetDimension() == 2)
              {
                System.out.println("             Number of nodes = (" + finfo.GetGridNX() + "," + finfo.GetGridNY() + ")");
                System.out.println("             Origin          = (" + finfo.GetGridX0() + "," + finfo.GetGridY0() + ")");
                System.out.println("             Mesh dimensions = (" + finfo.GetGridDX() + "," + finfo.GetGridDY() + ")");
                if (finfo.GetGridRotatedFlag())
                  System.out.println("             Rotation angle = " + finfo.GetGridAngleAroundZ());
                else
                  System.out.println("             No rotation");
              }
              else
              {
                System.out.println("             Number of nodes = (" + finfo.GetGridNX() + "," + finfo.GetGridNY() + "," + finfo.GetGridNZ() +
                                   ")");
                System.out.println("             Origin          = (" + finfo.GetGridX0() + "," + finfo.GetGridY0() + "," + finfo.GetGridZ0() +
                                   ")");
                System.out.println("             Mesh dimensions = (" + finfo.GetGridDX() + "," + finfo.GetGridDY() + "," + finfo.GetGridDZ() +
                                   ")");
                if (finfo.GetGridRotatedFlag())
                {
                  System.out.println("             Rotation angle around Z = " + finfo.GetGridAngleAroundZ());
                  System.out.println("             Rotation angle around Y = " + finfo.GetGridAngleAroundY());
                  System.out.println("             Rotation angle around X = " + finfo.GetGridAngleAroundX());
                }
                else
                  System.out.println("             No rotation");
              } // end of 3D
            } // end of if Grid Type

            String comment = client.GetFileComment();
            if (comment.length() != 0)
              System.out.println("           Comment: " + comment);

            // special variables information
            System.out.println("             Sample Number variable: " +
                               finfo.GetSampleNumberVariableName());
            if (finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_GRAVITY_LINES ||
                finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_GRAVITY_LINES)
            {
              System.out.println("             Line Number variable: " +
                                 finfo.GetLineNumberVariableName());
              System.out.println("             Relative Number variable: " +
                                 finfo.GetRelativeNumberVariableName());
            }
            System.out.println("             X Gravity Center variable: " +
                               finfo.GetXCoordinateVariableName());
            System.out.println("             Y Gravity Center variable: " +
                               finfo.GetYCoordinateVariableName());
            if (finfo.GetDimension() == 3)
              System.out.println("             Z Gravity Center variable: " +
                                 finfo.GetZCoordinateVariableName());


            if (finfo.GetFileType() == GTXFileInfo.FileType.FILE_TYPE_CORE_LINES)
            {
              System.out.println("X Core Begin variable: " + finfo.GetXCoreBeginVariableName() + "\n");
              System.out.println("Y Core Begin variable: " + finfo.GetYCoreBeginVariableName() + "\n");
              if (finfo.GetDimension() == 3)                             
                System.out.println("Z Core Begin variable: " + finfo.GetZCoreBeginVariableName() + "\n");
              
              System.out.println("X Core End variable: " + finfo.GetXCoreEndVariableName() + "\n");
              System.out.println("Y Core End variable: " + finfo.GetYCoreEndVariableName() + "\n");
              if (finfo.GetDimension() == 3)                             
                System.out.println("Z Core End variable: " + finfo.GetZCoreEndVariableName() + "\n");
            }
            


            if (finfo.GetFaultedFlag())
            {
              GTXFaultInfo fault_info = finfo.GetFaultInfo();
              System.out.println("\n             Faulted File:");
              System.out.println("             2D Faults: " +
                                 (fault_info.GetFaults2DFlag() ? 'Y': 'N'));
              System.out.println("             Auxiliary Variable Used: " +
                                 (fault_info.GetAuxiliaryVarUsedFlag()? 'Y': 'N'));
              System.out.println("             Number of faults: " +
                                 fault_info.GetFaultsNumber());
              System.out.println("             Number of segments: " +
                                 fault_info.GetSegmentsNumber());
              System.out.println("             Minimum Used Priority: " +
                                 fault_info.GetMinimumPriority());
              System.out.println("             Maximum Used Priority: " +
                                 fault_info.GetMaximumPriority());
              System.out.println("             Authorized Priority: " +
                                 fault_info.GetAuthorizedPriority());
            }
            String[] variables = client.GetVariableList().GetValues();
            for(int l=0; l<variables.length; l++)
            {
              System.out.println("\n         Variable: " + variables[l]);
              client.SetVariable(variables[l]);

              GTXVariableInfo vinfo = client.GetVariableInfo();
              switch (vinfo.GetVariableType())
              {
                case VAR_TYPE_FLOAT: type = "Float";            break;
                case VAR_TYPE_CHAR:  type = "Float";            break;
                case VAR_TYPE_XG:    type = "X Gravity Center"; break;
                case VAR_TYPE_YG:    type = "Y Gravity Center"; break;
                case VAR_TYPE_ZG:    type = "Z Gravity Center"; break;
                case VAR_TYPE_MACRO: type = "Macro";            break;
                default:             type = "Unknown";          break;
              }
              System.out.println("           Type: " + type);

              if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_CHAR)
              {
                System.out.println("           Alpha Length: " + vinfo.GetAlphaLength());
              }
              else
              {
                if (vinfo.GetBitLength() == 1)
                  System.out.println("           Precision: 1 bit (selection)");
                else
                {
                  System.out.println("           Precision: " + vinfo.GetBitLength() + " bits");
                  if (!vinfo.GetImplicitFlag())
                    System.out.println("           Unit: " + vinfo.GetUnit());
                }
              }
              comment = client.GetVariableComment();
              if (comment.length() != 0)
                System.out.println("           Comment: " + comment);
              if (vinfo.GetVariableType() == GTXVariableInfo.VariableType.VAR_TYPE_MACRO)
              {
                int indices[] = client.GetMacroIndices().GetValues();
                System.out.println("           Number of Indices: " + indices.length);
                if (indices.length != 0)
                {
                  for(int m=0; m<indices.length; m++)
                    System.out.printf("%6d", indices[m]);
                  System.out.println(".");
                  }
              }
              if (vinfo.GetVariableType()==GTXVariableInfo.VariableType.VAR_TYPE_FLOAT)
                statOnVariable(client);
            }
          }
        }
        catch (GTXError e)
        {
          System.err.println("GTXError: " + e.getMessage());
        }
      }
    }
    client.Disconnect();
  }

  public static void statOnVariable(GTXClient session) throws IOException {
    System.out.println("            Reading variable...");
    GTXDoubleData vdouble = session.ReadDoubleVariable(false);
    double max = -1e300;
    double min = 1e300;
    double mean = 0.;
    int nsamples = 0;

    double undef = vdouble.GetUndefinedValue();
    double[] vals = vdouble.GetValues();
    for (int n=0; n<vdouble.GetCount(); n++)
    {
      double val = vals[n];
      if (val != undef)
      {
        mean += val;
        min = ((val < min) ? val : min);
        max = ((val > max) ? val : max);
        nsamples++;
      }
    }
    System.out.println("            Computed min: " + min);
    System.out.println("            Computed max: " + max);
    System.out.println("           Computed mean: " + mean/nsamples);
  }
}
