/*****************************************************************************
 
            Copyright (c)94-98 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            38, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/
 
import java.io.*;
import java.util.*;

import com.geovariances.gtxclient.*;

class fault
{
  public static void usage(boolean help)
    {
      System.err.println("Usage: Fault [-help]");
      System.err.println("              [-host hostname] [-port port_number]");
      System.err.println("              [-path data_path]");
      if (help)
      {
        System.err.println(" -debug           : Print client/server messages.");
        System.err.println(" -host hostname   : Connect to a Server running on hostname.");
        System.err.println(" -port port_number: Port used by the already running server on given host");
        System.err.println(" -path data_path  : Initialize connection with given data_path.");
        System.err.println("The default is to run a new server on a random port.");
        System.err.println("If -host or -port is specified, a server must have been started first on the given host/port");
        System.exit(1);
      }
    }

  public static void main(String[] args) throws IOException
    {
      GTXClient client = new GTXClient();

      boolean run_server = true;
      String host = "localhost";
      String path = "";
      int port = 0;
      for (int i = 0; i < args.length; i++)
      {
        if (args[i].equals("-help")) { usage(true); return; }
        else if (args[i].equals("-debug")) { client.SetDebugMode(true); return; }
        else if (args[i].equals("-host")) {
          if (i == args.length-1) { usage(false); return; }
          run_server = false;
          host = args[++i];
        }
        else if (args[i].equals("-port")) {
          if (i == args.length-1) { usage(false); return; }
          run_server = false;
          port = Integer.parseInt(args[++i]);
        }
        else if (args[i].equals("-path")) {
          if (i == args.length-1) { usage(false); return; }
          path = args[++i];
        }
        else {
          usage(false);
          return;
        }
      }

      if (run_server)
      {
        port = client.RunGTXserver(0);
        host = "localhost";
      }
      else if (port == 0)
        port = client.GetDefaultPort();
      client.Connect(host, port, path);
      
    String study = "GTXserver_Tests";
    String directory = "FaultDirectory";
    String file = "File";
    String variable = "Var";

    String study_path = System.getProperty("java.io.tmpdir") + "/GTXserver_Tests";

    // You have to put there existing study,directory,file and variable
    //search is the Study existing, else create it and set it
    boolean isStudy = false;
    String list[] = client.GetStudyList().GetValues();
    for (int i = 0; i < list.length; i++){
      if (list[i].equals(study))
        isStudy = true;
    }
    if(!isStudy)
      client.NewStudy(study, study_path);
    client.SetStudy(study);
    //search is the Directory existing, else create it and set it
    if (!client.DirectoryExists(directory))
      client.NewDirectory(directory);
    client.SetDirectory(directory);
    //search is the File existing, else create it and set it
    if(!client.FileExists(file))
      client.NewGridFile3D(file,0.,0.,0.,1.,1.,1.,10,10,10);
    client.SetFile(file);

    try
    {
      //Create a segment
      GTXFaultSegment seg = new GTXFaultSegment();
      seg.SetX1(0.);
      seg.SetY1(0.);
      seg.SetZ1(0.);
      seg.SetX2(3.);
      seg.SetY2(3.);
      seg.SetZ2(0.);
      seg.SetX3(1.5);
      seg.SetY3(1.5);
      seg.SetZ3(5);
      seg.SetV1(1);
      seg.SetV2(2);
      seg.SetV3(3);
      seg.SetPriority(50);
      //Create another segment
      GTXFaultSegment seg2 = new GTXFaultSegment();
      seg2.SetX1(5.);
      seg2.SetY1(5.);
      seg2.SetZ1(0.);
      seg2.SetX2(10.);
      seg2.SetY2(10.);
      seg2.SetZ2(0.);
      seg2.SetX3(8.);
      seg2.SetY3(8.);
      seg2.SetZ3(7.);
      seg2.SetV1(1);
      seg2.SetV2(2);
      seg2.SetV3(3);
      seg2.SetPriority(50);
      //Create a fault with segments
      GTXFault fault = new GTXFault();
      fault.SetName("Fault");
      fault.SetPolygonalFlag(true);
      fault.AddFaultSegment(seg);
      fault.AddFaultSegment(seg2);
      //Create a FaultSystem with faults
      GTXFaultSystem InFaultSystem = new GTXFaultSystem();
      InFaultSystem.SetFaults2DFlag(false);
      InFaultSystem.SetAuxiliaryVarUsedFlag(true);
      InFaultSystem.SetAuxiliaryVarTest(-9999.99);
      InFaultSystem.AddFault( fault );
      //Write Fault
      client.WriteFaults(InFaultSystem);

        
      // Read and print all about the Fault System
      GTXFaultSystem RetFaultSystem = 
        client.ReadFaults(client.GetFileInfo().GetFaultInfo().GetAuthorizedPriority());
        
      String info = "";
      System.out.println("\nFault System:\n");

      if(RetFaultSystem.GetFaults2DFlag())
        System.out.println("Faults2dFlag is on \n");
      if(RetFaultSystem.GetAuxiliaryVarUsedFlag())
        System.out.println("GetAuxiliaryVarUsedFlag is on \n");
              
      System.out.println("AuxiliaryVarTest is " + RetFaultSystem.GetAuxiliaryVarTest() );
      System.out.println("FaultsNumber is " + RetFaultSystem.GetFaultsNumber() );

      for(int i = 0; i<RetFaultSystem.GetFaultsNumber();i++){
        System.out.println("\nFault :\n");
        System.out.println(" Name:  "+RetFaultSystem.GetFault(i).GetName());
        if(RetFaultSystem.GetFault(i).GetPolygonalFlag())
          System.out.println(" Polygonal Flag is on");
        System.out.println(" Segment Number:  "+RetFaultSystem.GetFault(i).GetSegmentsNumber());
                
        for(int j = 0; j<RetFaultSystem.GetFault(i).GetSegmentsNumber();j++){
          System.out.println("\n FaultSegment n"+j);
          System.out.println("  X1:"+RetFaultSystem.GetFault(i).GetSegment(j).GetX1());
          System.out.println("  Y1:"+RetFaultSystem.GetFault(i).GetSegment(j).GetY1());
          System.out.println("  Z1:"+RetFaultSystem.GetFault(i).GetSegment(j).GetZ1());
          System.out.println("  X2:"+RetFaultSystem.GetFault(i).GetSegment(j).GetX2());
          System.out.println("  Y2:"+RetFaultSystem.GetFault(i).GetSegment(j).GetY2());
          System.out.println("  Z2:"+RetFaultSystem.GetFault(i).GetSegment(j).GetZ2());
          System.out.println("  X3:"+RetFaultSystem.GetFault(i).GetSegment(j).GetX3());
          System.out.println("  Y3:"+RetFaultSystem.GetFault(i).GetSegment(j).GetY3());
          System.out.println("  Z3:"+RetFaultSystem.GetFault(i).GetSegment(j).GetZ3());
          System.out.println("  V1:"+RetFaultSystem.GetFault(i).GetSegment(j).GetV1());
          System.out.println("  V2:"+RetFaultSystem.GetFault(i).GetSegment(j).GetV2());
          System.out.println("  V3:"+RetFaultSystem.GetFault(i).GetSegment(j).GetV3());
          System.out.println("  Priority:"+RetFaultSystem.GetFault(i).GetSegment(j).GetPriority());

          System.out.println(info);            

        }
      }

    }
    catch (GTXError e)
    {
      System.err.println("GTXError: " + e.getMessage());
    }
    
    client.Disconnect();
    
    }
}
