/*****************************************************************************
 
            Copyright (c)94-98 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            38, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/
 
import java.io.*;
import java.util.*;

import com.geovariances.gtxclient.*;

class polygon
{
  public static void usage(boolean help)
    {
      System.err.println("Usage: Polygon [-help]");
      System.err.println("              [-host hostname] [-port port_number]");
      System.err.println("              [-path data_path]");
      if (help)
      {
        System.err.println(" -debug           : Print client/server messages.");
        System.err.println(" -host hostname   : Connect to a Server running on hostname.");
        System.err.println(" -port port_number: Port used by the already running server on given host");
        System.err.println(" -path data_path  : Initialize connection with given data_path.");
        System.err.println("The default is to run a new server on a random port.");
        System.err.println("If -host or -port is specified, a server must have been started first on the given host/port");
        System.exit(1);
      }
    }

  public static void main(String[] args) throws IOException
    {
      GTXClient client = new GTXClient();

      boolean run_server = true;
      String host = "localhost";
      String path = "";
      int port = 0;
      for (int i = 0; i < args.length; i++)
      {
        if (args[i].equals("-help")) { usage(true); return; }
        else if (args[i].equals("-debug")) { client.SetDebugMode(true); return; }
        else if (args[i].equals("-host")) {
          if (i == args.length-1) { usage(false); return; }
          run_server = false;
          host = args[++i];
        }
        else if (args[i].equals("-port")) {
          if (i == args.length-1) { usage(false); return; }
          run_server = false;
          port = Integer.parseInt(args[++i]);
        }
        else if (args[i].equals("-path")) {
          if (i == args.length-1) { usage(false); return; }
          path = args[++i];
        }
        else {
          usage(false);
          return;
        }
      }

      if (run_server)
      {
        port = client.RunGTXserver(0);
        host = "localhost";
      }
      else if (port == 0)
        port = client.GetDefaultPort();
      client.Connect(host, port, path);
      
    String study = "GTXserver_Tests";
    String directory = "PolygonDirectory";
    String file = "PoligonFile";

    String study_path = System.getProperty("java.io.tmpdir") + "/GTXserver_Tests";

    // You have to put there existing study,directory,file and variable
    //search is the Study existing, else create it and set it
    boolean isStudy = false;
    String list[] = client.GetStudyList().GetValues();
    for (int i = 0; i < list.length; i++){
      if (list[i].equals(study))
        isStudy = true;
    }
    if(!isStudy)
      client.NewStudy(study, study_path);
    client.SetStudy(study);
    //search is the Directory existing, else create it and set it
    if (!client.DirectoryExists(directory))
      client.NewDirectory(directory);
    client.SetDirectory(directory);

    try
    {

      //Create Polygon
      GTXPolygon poly = new GTXPolygon();
      poly.SetName("Polygon1");
      poly.SetGroupName("Group1");
      poly.SetZMin(-50.);       
      poly.SetZMax(50.);
      poly.AddVertex(0., 0.);
      poly.AddVertex(10., 0.);
      poly.AddVertex(10., 10.);
      poly.AddVertex(0., 10.);
      //Create another Polygon
      GTXPolygon poly2 = new GTXPolygon();
      poly2.SetName("Polygon2");
      poly2.SetGroupName("Group1");
      poly2.SetZMin(-5.);       
      poly2.SetZMax(5.);
      poly2.AddVertex(-5., -5.);
      poly2.AddVertex(1., 0.);
      poly2.AddVertex(1., 1.);


      //Create Polygon System
      GTXPolygonSystem polysys = new GTXPolygonSystem();
      polysys.SetPolygons2DFlag(true);
      polysys.AddPolygon(poly);
      polysys.AddPolygon(poly2);
        
      //Add to the study
      if (client.FileExists(file)){
        client.SetFile(file);
        client.DeleteFile();
          }
      client.NewPolygonsFile(file,polysys );
      
      //Read Polygon System
      client.SetFile(file);
      GTXPolygonSystem retpolysys = client.ReadPolygons();

      //Display information about the PolygonSystem read
      if (retpolysys.GetPolygons2DFlag())
        System.out.println("Flag Polygon 2D on\n");
      System.out.println("MinimumExtensionX :"+retpolysys.GetMinimumExtensionX());
      System.out.println("MinimumExtensionY :"+retpolysys.GetMinimumExtensionY());
      System.out.println("MinimumExtensionZ :"+retpolysys.GetMinimumExtensionZ());
      System.out.println("MaximumExtensionX :"+retpolysys.GetMaximumExtensionX());
      System.out.println("MaximumExtensionY :"+retpolysys.GetMaximumExtensionY());
      System.out.println("MaximumExtensionZ :"+retpolysys.GetMaximumExtensionZ());
      System.out.println("PolygonsNumber :"+retpolysys.GetPolygonsNumber());




      for (int i = 0; i<retpolysys.GetPolygonsNumber(); i++){
        System.out.println("\n\tName :" + retpolysys.GetPolygon(i).GetName());
        System.out.println("\tGroupName :" + retpolysys.GetPolygon(i).GetGroupName());
        System.out.println("\tGetZMin :" + retpolysys.GetPolygon(i).GetZMin());
        System.out.println("\tGetZMax :" + retpolysys.GetPolygon(i).GetZMax());
        System.out.println("\tVerticesNumber :" + retpolysys.GetPolygon(i).GetVerticesNumber());

        System.out.println("\tX\tY");        
        for (int j =0; j<retpolysys.GetPolygon(i).GetVerticesNumber(); j++)
          System.out.println("\t"+ retpolysys.GetPolygon(i).GetXVertices(j) +"\t"+ retpolysys.GetPolygon(i).GetYVertices(j));

      }

    }
    catch (GTXError e)
    {
      System.err.println("GTXError: " + e.getMessage());
    }
    
    client.Disconnect();
    
    }
}
