/*****************************************************************************
 
            Copyright (c)94-98 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            38, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/
 
import java.io.*;
import java.util.*;

import com.geovariances.gtxclient.*;

class vendor
{
  public static void usage(boolean help)
  {
    System.err.println("Usage: Vendor [-help]");
    System.err.println("              [-host hostname] [-port port_number]");
    System.err.println("              [-path data_path]");
    if (help)
    {
      System.err.println(" -debug           : Print client/server messages.");
      System.err.println(" -host hostname   : Connect to a Server running on hostname.");
      System.err.println(" -port port_number: Port used by the already running server on given host");
      System.err.println(" -path data_path  : Initialize connection with given data_path.");
      System.err.println("The default is to run a new server on a random port.");
      System.err.println("If -host or -port is specified, a server must have been started first on the given host/port");
      System.exit(1);
    }
  }

  public static void main(String[] args) throws IOException
  {
    GTXClient client = new GTXClient();

    boolean run_server = true;
    String host = "localhost";
    String path = "";
    int port = 0;
    for (int i = 0; i < args.length; i++)
    {
      if (args[i].equals("-help")) { usage(true); return; }
      else if (args[i].equals("-debug")) { client.SetDebugMode(true); return; }
      else if (args[i].equals("-host")) {
        if (i == args.length-1) { usage(false); return; }
        run_server = false;
        host = args[++i];
      }
      else if (args[i].equals("-port")) {
        if (i == args.length-1) { usage(false); return; }
        run_server = false;
        port = Integer.parseInt(args[++i]);
      }
      else if (args[i].equals("-path")) {
        if (i == args.length-1) { usage(false); return; }
        path = args[++i];
      }
      else {
        usage(false);
        return;
      }
    }

    if (run_server)
    {
      port = client.RunGTXserver(0);
      host = "localhost";
    }
    else if (port == 0)
      port = client.GetDefaultPort();
    client.Connect(host, port, path);

    String study = "GTXserver_Tests";
    String directory = "VendorDirectory";
    String file = "File";
    String variable = "Var";

    String study_path = System.getProperty("java.io.tmpdir") + "/GTXserver_Tests";

    // You have to put there existing study,directory,file and variable
    //search is the Study existing, else create it and set it
    boolean isStudy = false;
    String list[] = client.GetStudyList().GetValues();
    for (int i = 0; i < list.length; i++){
      if (list[i].equals(study))
        isStudy = true;
    }
    if (!isStudy)
      client.NewStudy(study, study_path);
    client.SetStudy(study);
    //search is the Directory existing, else create it and set it
    if (!client.DirectoryExists(directory))
      client.NewDirectory(directory);
    client.SetDirectory(directory);
    //search is the File existing, else create it and set it
    if (!client.FileExists(file))
      client.NewGridFile2D(file,0.,0.,1.,1.,10,10);
    client.SetFile(file);

    int [] intArray = {100,200,300,1024};
    double [] dblArray = {100.,200.,300.};
    String [] strArray = {"string 1", "string 2", "string 3"};

    // create a new vendor data
    GTXVendorData vendorData = new GTXVendorData("Java App",100);

    try
    {

      // add different types of attributes
      vendorData.AddAttributeInt("Attribut 0", 100);
      vendorData.AddAttributeDouble("Attribut 1", 200.);
      vendorData.AddAttributeString("Attribut 2", "hello");


      GTXIntArray intarray = new GTXIntArray(intArray.length, intArray);

      GTXStringArray strarray = new GTXStringArray();
      strarray.Resize(strArray.length);
      for(int i = 0; i<strarray.GetCount(); i++)
             strarray.SetValue(i,strArray[i] );

      GTXDoubleArray dblarray = new GTXDoubleArray(dblArray.length, dblArray);

      vendorData.AddAttributeIntArray("Attribut 3", intarray);
      vendorData.AddAttributeDoubleArray("Attribut 4", dblarray);
      vendorData.AddAttributeStringArray("Attribut 5", strarray);


      // we'll store vendor data at the File level (2)
      int level = 2;

      // write the vendor data
      client.VendorDataWrite(level,vendorData);

      // check vendor data version
      int version = client.VendorDataGetVersion("Java App",level);
      System.out.println("Vendor Data Version is " + version);

      // read the vendor data back
      vendorData = client.VendorDataRead("Java App",level);

      // vendor data version can also be found after a complete read
      System.out.println("Vendor Data Version is " + vendorData.GetVersion());

      // retrieve attribute values. They can be retrieved in any order
      GTXIntArray retIntArray =
        vendorData.GetAttributeIntArray("Attribut 3");
      GTXDoubleArray retDoubleArray =
        vendorData.GetAttributeDoubleArray("Attribut 4");
      GTXStringArray retStringArray =
        vendorData.GetAttributeStringArray("Attribut 5");

      int retInt = vendorData.GetAttributeInt("Attribut 0");
      double retDouble = vendorData.GetAttributeDouble("Attribut 1");
      String retString = vendorData.GetAttributeString("Attribut 2");


      // you can generate an exception like this
      // int retIntError = vendorData.GetAttributeInt("Attribut 12");

      // dump values
      System.out.println("Retrieved Int Attribute is " + retInt);
      System.out.println("Retrieved Double Attribute is " + retDouble);
      System.out.println("Retrieved String Attribute is " + retString);

      System.out.println("Retrieved Int Array Attribute is");
      for (int i = 0; i < retIntArray.GetCount(); i++)
        System.out.println("  " + retIntArray.GetValue(i));
      System.out.println("Retrieved Double Array Attribute is");
      for (int i = 0; i < retDoubleArray.GetCount(); i++)
        System.out.println("  " + retDoubleArray.GetValue(i));
      System.out.println("Retrieved String Array Attribute is");
      for (int i = 0; i < retStringArray.GetCount(); i++)
        System.out.println("  " + retStringArray.GetValue(i));
    }
    catch (GTXError e)
    {
      System.err.println("GTXError: " + e.getMessage());
    }

    client.Disconnect();

  }
}
