#ifndef __GTXByteArray_hpp__
#define __GTXByteArray_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG

/*!
 * \brief Class for handling an array of bytes
 */
class GLOBAL_CLASS GTXByteArray
{
public:
  //! empty constructor
  GTXByteArray();
  //! constructor from a count of items and a C byte array
  GTXByteArray(gtx_long count, unsigned char values[]);
  //! destructor
  ~GTXByteArray();
  //! copy contructor
  GTXByteArray(const GTXByteArray &in_bytearray);
#ifndef SWIG
  //! operator =
  GTXByteArray &operator=(const GTXByteArray &in_bytearray);
#endif

  //! Get the number of byte in the list
  gtx_long GetCount(void) const;
  void Resize(gtx_long count);
  //! Get the rank'th unsigned char (0 <= rank < count)
  unsigned char GetValue(gtx_long rank) const;

  //! Set the rank'th unsigned char (0 <= rank < count)
  void SetValue(gtx_long rank, unsigned char value);

  //! Get the complete values array
  const unsigned char *GetValues() const;

private:
  gtx_long _count;
  unsigned char *_values;
};

#endif //__GTXByteArray_hpp__
