#ifndef __GTXCharData_hpp__
#define __GTXCharData_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG

#include <GTXStringArray.hpp>
/*!
 * \brief Class for handling a alphanumerical variable data
 */
class GLOBAL_CLASS GTXCharData : public GTXStringArray
{
public:
  //! empty constructor
  GTXCharData();
  //! destructor
  ~GTXCharData();
#ifndef SWIG
  //! constructor from a count of items and a C string array
  GTXCharData(gtx_long count, const char * const*list);
#endif
  //! copy contructor
  GTXCharData(const GTXCharData &in_chrdata);
#ifndef SWIG
  //! operator =
  GTXCharData &operator=(const GTXCharData &in_chrdata);
#endif

  //! Get the undefined value
  const char *GetUndefinedValue() const;
  //! Set the undefined value
  void SetUndefinedValue(const char *undef_val);



private:
  char *_undef_val;

  friend class GTXClient;
};

#endif //__GTXCharData_hpp__
