/*****************************************************************************

            Copyright (c)2007 Geovariances, Avon, France.

    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.

    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).

            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE

             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr

                        All Rights Reserved

*****************************************************************************/

#ifndef _GTXClientP_h
#define _GTXClientP_h

#include <GTXClient.h>
#include <GTXPacket.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef enum
{
  _GTX_VENDOR_DATA_TYPE_NOTHING,
  _GTX_VENDOR_DATA_TYPE_INT,
  _GTX_VENDOR_DATA_TYPE_DOUBLE,
  _GTX_VENDOR_DATA_TYPE_STRING,
  _GTX_VENDOR_DATA_TYPE_INT_ARRAY,
  _GTX_VENDOR_DATA_TYPE_DOUBLE_ARRAY,
  _GTX_VENDOR_DATA_TYPE_STRING_ARRAY,
  _GTX_VENDOR_DATA_TYPE_NUMBER
} _GTX_VENDOR_DATA_TYPE;

typedef struct _GTXVendorDataAttrRec
{
  char name[50];
  _GTX_VENDOR_DATA_TYPE type;
  int nvalues;
  union
  {
    int val_int;
    double val_double;
    char *val_string;
    int *int_array;
    double *double_array;
    char **string_array;
  } values;
  struct _GTXVendorDataAttrRec *next;
} GTXVendorDataAttrRec;

typedef struct _GTXVendorDataRec
{
  char identificator[50];
  int version;
  GTXVendorDataAttrRec *attributes;
} GTXVendorDataRec;

#if defined(solaris) || defined(irix) || defined(sunos)
#include <sys/types.h>
#endif

#if (defined(aix) && !defined(_AIX43)) || \
    (defined(solaris) && defined(__SunOS_5_5_1)) || \
    defined(winnt)
typedef int int32_t;
#endif

#if !defined(bool_t)
typedef int bool_t;
#endif

#if !defined(TRUE)
#define TRUE  (1)
#define FALSE (0)
#endif

#if defined(winnt)
#include <winsock.h>
typedef SOCKET _GTX_SOCKET;
#define _GTX_SOCKET_ERROR SOCKET_ERROR
#define strdup _strdup
#else
#include <sys/socket.h>
typedef int _GTX_SOCKET;
#define _GTX_SOCKET_ERROR (-1)
#endif

#ifndef _GTX_UNUSED
# if defined(_GNU_SOURCE) || defined(__GNUC__)
#  define _GTX_UNUSED __attribute__((unused))
# else
#  define _GTX_UNUSED
# endif
#endif

/* Can have colors to make some texts clearer */
#if 0
#define DEBUG_COLOR_ON  "[00;34m"
#define DEBUG_COLOR_OFF "[00m"
#else
#define DEBUG_COLOR_ON
#define DEBUG_COLOR_OFF
#endif

/* Useful defines for version tests... */
/* SERVER_4_1 indicate a version >= 4.1 with unit management, study path...*/
#define SERVER_4_1 (_gtx_client_server_version >= 401000 || \
                    (_gtx_client_server_version < 400000 && \
                     _gtx_client_server_version >= 410))
/* SERVER_REQ_4_1_1 indicate a version >= 4.1.1 with modification of requests
   to read/write double variable... (4.0.7 does this too) */
#define SERVER_REQ_4_1_1 (_gtx_client_server_version > 400000 || \
                          (_gtx_client_server_version < 410 && \
                           _gtx_client_server_version >= 407) || \
                          _gtx_client_server_version >= 411)

/* Tracing */
/* Tracing levels: */
/* - 1: for main function calls */
/* - 2: 1+prints Packets contents */
/* - 3: 2+prints progress steps in functions */
/* - 4: 3+prints running steps (before connection) */
#define GTX_TRACE(L,f) if(L<=_gtx_trace_level)_gtx_trace f
#define GTX_TRACE_FUNC_START(f,a) if(1<=_gtx_trace_level)_gtx_trace_func_start(f,a)
#define GTX_TRACE_FUNC_END(f,p) if(1<=_gtx_trace_level)_gtx_trace_func_end(f,p)

/* Init Check */
#define CHECK_INIT(if_error) if (_gtx_client_linked_version == 0) { \
                                _gtx_error("GTXClient library has not been initialized"); \
                                if_error \
                              }

#ifdef __cplusplus
extern "C"
{
#endif
/* Private variables to the library */
extern _GTX_SOCKET _gtx_server_socket;
extern int _gtx_client_dbg_mode;
extern int _gtx_client_server_version; /* server version */
extern int _gtx_client_linked_version; /* used version at linked */
extern int _gtx_client_n_supported_requests;
extern char **_gtx_client_supported_requests;
extern int _gtx_is_server;   /* 1 if we are server, 0 in the client */
extern int _gtx_trace_level;
extern FILE * _gtx_trace_file;
extern int _gtx_disable_rw_trace;
extern int _gtx_client64;
extern int _gtx_server64;
extern GTXErrorCode _gtx_client_last_error;

/* Private functions */
#if defined(winnt)
#define _gtx_serror _gtx_herror
#else
#define _gtx_serror _gtx_perror
#endif
extern void _gtx_debug(char *format, ...);
extern void _gtx_error(char *format, ...);
extern void _gtx_perror(char *format, ...);
extern void _gtx_herror(char *format, ...);
extern void _gtx_trace_init(void);
extern void _gtx_trace(char *format, ...);
extern void _gtx_trace_func_start(char *function, int args);
extern void _gtx_trace_func_end(char *format, ...);
extern void _gtx_trace_end(void);
extern int _gtx_is_supported(char *request, int generate_error);
extern int _gtx_exec_server(char *GTXserver_path, char *args[]);
extern int _gtx_listen_port(unsigned short *port, int wait_queue_length, _GTX_SOCKET *listen_socket);
extern int _gtx_wait_connect(_GTX_SOCKET listen_socket, _GTX_SOCKET *comm_socket, int blocking, int timeout);
extern int _gtx_connect(const char *host, unsigned short port, _GTX_SOCKET *comm_socket);
extern void _gtx_close_socket(_GTX_SOCKET *sockptr);
extern int _gtx_init_client(const char *host, unsigned short port);
extern int _gtx_start_packet(char *type);
extern int _gtx_send_and_wait(char *answer);
extern int _gtx_check_answer(char *received_type, char *expected_type);
extern void _gtx_cleanup_socket(void);
extern void _gtx_close_client(void);
extern bool_t _gtx_flush_write(_GTX_SOCKET s);
extern void _gtx_empty_write_buffer(void);
extern int _gtx_winsock_init(void);
extern void _gtx_winsock_free(void);
extern GTXVendorDataAttrRec *_gtx_vendor_data_search_attribute(GTXVendorData_C vendor_data, const char *name, _GTX_VENDOR_DATA_TYPE exp_type);
  extern GTXErrorCode _gtx_get_line_samples(int *nlines, int **scount);

extern bool_t _gtx_read_bytes(_GTX_SOCKET s, void *addr, gtx_ulong len);
extern bool_t _gtx_read_int(_GTX_SOCKET s, int *ip);
extern bool_t _gtx_read_long(_GTX_SOCKET s, gtx_long *lp);
extern bool_t _gtx_read_uint(_GTX_SOCKET s, unsigned int *uip);
extern bool_t _gtx_read_short(_GTX_SOCKET s, short *sp);
extern bool_t _gtx_read_ushort(_GTX_SOCKET s, unsigned short *usp);
extern bool_t _gtx_read_char(_GTX_SOCKET s, char *cp);
extern bool_t _gtx_read_uchar(_GTX_SOCKET s, unsigned char *ucp);
extern bool_t _gtx_read_double(_GTX_SOCKET s, double *dp);
extern bool_t _gtx_read_bool(_GTX_SOCKET s, bool_t *bp);
extern bool_t _gtx_read_string(_GTX_SOCKET s, char **cpp, unsigned int maxsize);

extern bool_t _gtx_write_bytes(_GTX_SOCKET s, const void *addr, gtx_ulong len); 
extern bool_t _gtx_write_int(_GTX_SOCKET s, const int *ip);
extern bool_t _gtx_write_long(_GTX_SOCKET s, const gtx_long *lp);
extern bool_t _gtx_write_uint(_GTX_SOCKET s, const unsigned int *uip);
extern bool_t _gtx_write_short(_GTX_SOCKET s, const short *sp);
extern bool_t _gtx_write_ushort(_GTX_SOCKET s, const unsigned short *usp);
extern bool_t _gtx_write_char(_GTX_SOCKET s, const char *cp);
extern bool_t _gtx_write_uchar(_GTX_SOCKET s, const unsigned char *ucp);
extern bool_t _gtx_write_double(_GTX_SOCKET s, const double *dp);
extern bool_t _gtx_write_bool(_GTX_SOCKET s, const bool_t *bp);
extern bool_t _gtx_write_string(_GTX_SOCKET s, const char * const *cpp, unsigned int maxsize);
typedef bool_t (*_gtx_proc_rw_t)(_GTX_SOCKET , void *,...);
extern bool_t _gtx_rw_vector(_GTX_SOCKET s, char *basep, gtx_ulong nelem, unsigned int elemsize, _gtx_proc_rw_t rw_proc);
#ifdef __cplusplus
}
#endif
#endif
