#ifndef __GTXDoubleArray_hpp__
#define __GTXDoubleArray_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG

/*!
 * \brief Class for handling a floating variable data
 */
class GLOBAL_CLASS GTXDoubleArray
{
public:
  //! empty constructor
  GTXDoubleArray();
  //! constructor from a count of items and a C double array
  GTXDoubleArray(gtx_long count, double values[]);
  //! destructor
  ~GTXDoubleArray();
  //! copy contructor
  GTXDoubleArray(const GTXDoubleArray &in_dbldata);
#ifndef SWIG
  //! operator =
  GTXDoubleArray &operator=(const GTXDoubleArray &in_dbldata);
#endif

  //! Get the number of values in the array
  gtx_long GetCount(void) const;
  //! Resize the array (keeps the old values when possible)
  void Resize(gtx_long count);


  //! Get the rank'th value (0 <= rank < count)
  double GetValue(gtx_long rank) const;
  //! Get the complete values array
  const double *GetValues() const;
  //! Set the rank'th value (0 <= rank < count)
  void SetValue(gtx_long rank, double value);

  //! Set All the Values at once (array must have been resized before)
  void SetValues(double values[]);

private:
  gtx_long _count;
  double *_values;
  int *_ref;
  
  //! Store values pointer as is (should not be freed by caller)
  void StorePointer(double *values, gtx_long count);
  //! Decrement ref and free it if null
  void Unref();

  friend class GTXClient;
};

#endif //__GTXDoubleArray_hpp__
