#ifndef __GTXDoubleData_hpp__
#define __GTXDoubleData_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG

#include <GTXDoubleArray.hpp>

/*!
 * \brief Class for handling a floating variable data
 */
class GLOBAL_CLASS GTXDoubleData : public GTXDoubleArray
{
public:
  //! empty constructor
  GTXDoubleData();
  //! constructor from a count of items and a C double array
  GTXDoubleData(gtx_long count, double values[]);
  //! destructor
  ~GTXDoubleData();
  //! copy contructor
  GTXDoubleData(const GTXDoubleData &in_dbldata);
#ifndef SWIG
  //! operator =
  GTXDoubleData &operator=(const GTXDoubleData &in_dbldata);
#endif


  //! Get the undefined value
  double GetUndefinedValue() const;
  //! Set the undefined value
  void SetUndefinedValue(double undef_val);


private:
  double _undef_val;

  friend class GTXClient;
};

#endif //__GTXDoubleData_hpp__
