/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#ifndef __GTXFaultInfo_hpp__
#define __GTXFaultInfo_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG

/*!
 * \brief Information on \a Fault \a System associated with a given file.
 */
class GLOBAL_CLASS GTXFaultInfo
{
public:
  //! empty contructor
  GTXFaultInfo();
  //! copy contructor
  GTXFaultInfo(const GTXFaultInfo &in_finfo);

  //! Says whetever the Faults are defined in 2D
  bool GetFaults2DFlag();
  //! Says whetever some auxiliary variables are defined in this fault system
  bool GetAuxiliaryVarUsedFlag();
  //! Get Total Number of faults
  int GetFaultsNumber();
  //! Get Total Number of segments
  int GetSegmentsNumber();
  //! Get Minimum fault priority
  int GetMinimumPriority();
  //! Get Maximum fault priority
  int GetMaximumPriority();
  //! Get Authorized priority (minimum taken into account)
  int GetAuthorizedPriority();

private:
  GTXFaultInfo_C _cinfo;
  friend class GTXFileInfo;
};

//! empty contructor
inline GTXFaultInfo::GTXFaultInfo()
{
}

//! copy contructor
inline GTXFaultInfo::GTXFaultInfo(const GTXFaultInfo &in_finfo)
{
  _cinfo = in_finfo._cinfo;
}

inline bool GTXFaultInfo::GetFaults2DFlag()
{
  return _cinfo.faults_2d != 0;
}

inline bool GTXFaultInfo::GetAuxiliaryVarUsedFlag()
{
  return _cinfo.aux_var_used != 0;
}

inline int GTXFaultInfo::GetFaultsNumber()
{
  return _cinfo.faults_number;
}

inline int GTXFaultInfo::GetSegmentsNumber()
{
  return _cinfo.segments_number;
}

inline int GTXFaultInfo::GetMinimumPriority()
{
  return _cinfo.min_fpriority;
}

inline int GTXFaultInfo::GetMaximumPriority()
{
  return _cinfo.max_fpriority;
}

inline int GTXFaultInfo::GetAuthorizedPriority()
{
  return _cinfo.auth_priority;
}

#endif // __GTXFaultInfo_hpp__
