/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#ifndef __GTXFaultSegment_hpp__
#define __GTXFaultSegment_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG



/*!
 * \brief Class for handling Vendor Data
 */
class GLOBAL_CLASS GTXFaultSegment
{
public:
  GTXFaultSegment();
  GTXFaultSegment(const GTXFaultSegment &fseg);
#ifndef SWIG
  GTXFaultSegment operator=(const GTXFaultSegment &fseg);
#endif
  ~GTXFaultSegment();
  double GetX1()const;
  double GetY1()const;
  double GetZ1()const;
  double GetX2()const;
  double GetY2()const;
  double GetZ2()const;
  double GetX3()const;
  double GetY3()const;
  double GetZ3()const;
  double GetV1()const;
  double GetV2()const;
  double GetV3()const;
  int GetPriority()const;
  
  void SetX1(double X1);
  void SetY1(double Y1);
  void SetZ1(double Z1);
  void SetX2(double X2);
  void SetY2(double Y2);
  void SetZ2(double Z2);
  void SetX3(double X3);
  void SetY3(double Y3);
  void SetZ3(double Z3);
  void SetV1(double V1);
  void SetV2(double V2);
  void SetV3(double V3);
  void SetPriority(int priority);

  
private:
  GTXFaultSegment_C *_fseg;

  friend class GTXClient;
  friend class GTXFault;
};

#endif // __GTXFaultSegment_hpp__
