/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#ifndef __GTXFaultSystem_hpp__
#define __GTXFaultSystem_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG
#include <GTXFault.hpp>

/*!
 * \brief Class for handling Vendor Data
 */
class GLOBAL_CLASS GTXFaultSystem
{
public:
  GTXFaultSystem();
  GTXFaultSystem(const GTXFaultSystem &fsys);
#ifndef SWIG
  GTXFaultSystem operator=(const GTXFaultSystem &sys);
#endif
  ~GTXFaultSystem();
  

  bool GetFaults2DFlag()const;
  bool GetAuxiliaryVarUsedFlag()const;
  double GetAuxiliaryVarTest()const;
  int GetFaultsNumber()const;
  GTXFault GetFault(int rank)const;
  
  void SetFaults2DFlag(bool value);
  void SetAuxiliaryVarUsedFlag(bool avu);
  void SetAuxiliaryVarTest(double avt);
  void AddFault(const GTXFault &fault);



private:
  GTXFaultSystem_C *_fsys;

  friend class GTXClient;
};

#endif // __GTXFaultSystem_hpp__
