/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#ifndef __GTXFileInfo_hpp__
#define __GTXFileInfo_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>

class GTXFaultInfo;
#endif //SWIG

/*!
 * \brief Class for handling Information on a file
 */
class GLOBAL_CLASS GTXFileInfo
{
public:
  //! empty contructor
  GTXFileInfo();
  //! copy contructor
  GTXFileInfo(const GTXFileInfo &in_finfo);

  /*!
   * \enum FileType
   * Define the different types of file that can be read from or written to the
   * Isatis file system.
   */
  enum FileType
  {
    FILE_TYPE_ANY     = -1, /*!< Any kind of file (used only for queries) */
    FILE_TYPE_POINTS,       /*!< Points */
    FILE_TYPE_GRAVITY_LINES,/*!< Lines  */
    FILE_TYPE_CORE_LINES,   /*!< Lines  */
    FILE_TYPE_GRID,         /*!< Grid   */
    FILE_TYPE_INVALID       /*!< Invalid type */
  };

  //! Get file type
  FileType GetFileType();
  //! Get the name of the linked file (or empty if non-applicable)
  const char *GetLinkedFileName();
  //! Get the faulting status of the file (true if faulted)
  bool GetFaultedFlag();
  //! Check is this file is a polygon file (true if it is (can only be true for a Points file)).
  bool GetPolygonFlag();
  //! Get the Dimenstion of the file (2 for a 2D file, 3 for a 3D one)
  int GetDimension();
  //! Get the number of samples in this file
  gtx_long GetSampleNumber();
  //! Get the number of lines in this file (if the files is a Lines file)
  int GetItemNumber();
  //! Get the X coordinate of the origin of the grid (if a \a Grid file)
  double GetGridX0();
  //! Get the Y coordinate of the origin of the grid (if a \a Grid file)
  double GetGridY0();
  //! Get the Z coordinate of the origin of the grid (if a \a Grid file)
  double GetGridZ0();
  //! get the X mesh dimensions (if a \a Grid file)
  double GetGridDX();
  //! get the Y mesh dimensions (if a \a Grid file)
  double GetGridDY();
  //! get the Z mesh dimensions (if a \a Grid file)
  double GetGridDZ();
  //! Get the number of grid nodes along X (if a \a Grid file)
  int GetGridNX();
  //! Get the number of grid nodes along Y (if a \a Grid file)
  int GetGridNY();
  //! Get the number of grid nodes along Z (if a \a Grid file)
  int GetGridNZ();
  //! Indicate whetever the grid is rotated or not (true if rotated)
  bool GetGridRotatedFlag();
  //! Get the Grid rotation angle around OZ (for a 2D or 3D Rotated Grid file)
  double GetGridAngleAroundZ();
  //! Get the Grid rotation angle around OY (for a 3D Rotated Grid file)
  double GetGridAngleAroundY();
  //! Get the Grid rotation angle around OX (for a 3D Rotated Grid file)
  double GetGridAngleAroundX();

  //! Get the Sample Number variable name */
  const char *GetSampleNumberVariableName();
  //! Get the Line Name variable name (if a Points file linked to a Lines file)
  const char *GetLineNameVariableName();
  //! Get the Line Number variable name (if a Lines file)
  const char *GetLineNumberVariableName();
  //! Get the Relative Number variable name (if a Lines file)
  const char *GetRelativeNumberVariableName();
  //! Get the X Gravity Center variable name (if a Lines file)
  const char *GetXCoordinateVariableName();
  //! Get the Y Gravity Center variable name (if a Lines file)
  const char *GetYCoordinateVariableName();
  //! Get the Z Gravity Center variable name (if a Lines file)
  const char *GetZCoordinateVariableName();

  //! Get the X Core Begin variable name (if a Lines file)
  const char *GetXCoreBeginVariableName();
  //! Get the Y Core Begin variable name (if a Lines file)
  const char *GetYCoreBeginVariableName();
  //! Get the Z Core Begin variable name (if a Lines file)
  const char *GetZCoreBeginVariableName();
  //! Get the X Core Begin variable name (if a Lines file)
  const char *GetXCoreEndVariableName();
  //! Get the Y Core End variable name (if a Lines file)
  const char *GetYCoreEndVariableName();
  //! Get the Z Core End variable name (if a Lines file)
  const char *GetZCoreEndVariableName();

  //! Get the Fault Information (if the file is faulted)
  GTXFaultInfo GetFaultInfo();

private:
  GTXFileInfo_C _cinfo;
  friend class GTXClient;
};

//! empty contructor
inline GTXFileInfo::GTXFileInfo()
{
}

//! copy contructor
inline GTXFileInfo::GTXFileInfo(const GTXFileInfo &in_finfo)
{
  _cinfo = in_finfo._cinfo;
}

inline GTXFileInfo::FileType GTXFileInfo::GetFileType()
{
  return (GTXFileInfo::FileType)_cinfo.type;
}

inline const char *GTXFileInfo::GetLinkedFileName()
{
  return _cinfo.linked_file;
}

inline bool GTXFileInfo::GetFaultedFlag()
{
  return _cinfo.faulted != 0;
}

inline bool GTXFileInfo::GetPolygonFlag()
{
  return _cinfo.polygon_file != 0;
}

inline int GTXFileInfo::GetDimension()
{
  return _cinfo.dimension;
}

inline gtx_long GTXFileInfo::GetSampleNumber()
{
  return _cinfo.s_number;
}

inline int GTXFileInfo::GetItemNumber()
{
  return _cinfo.item_number;
}

inline double GTXFileInfo::GetGridX0()
{
  return _cinfo.X0;
}

inline double GTXFileInfo::GetGridY0()
{
  return _cinfo.Y0;
}

inline double GTXFileInfo::GetGridZ0()
{
  return _cinfo.Z0;
}

inline double GTXFileInfo::GetGridDX()
{
  return _cinfo.DX;
}

inline double GTXFileInfo::GetGridDY()
{
  return _cinfo.DY;
}

inline double GTXFileInfo::GetGridDZ()
{
  return _cinfo.DZ;
}

inline int GTXFileInfo::GetGridNX()
{
  return _cinfo.NX;
}

inline int GTXFileInfo::GetGridNY()
{
  return _cinfo.NY;
}

inline int GTXFileInfo::GetGridNZ()
{
  return _cinfo.NZ;
}

inline bool GTXFileInfo::GetGridRotatedFlag()
{
  return _cinfo.rotation != 0;
}

inline double GTXFileInfo::GetGridAngleAroundZ()
{
  return _cinfo.angle_z;
}

inline double GTXFileInfo::GetGridAngleAroundY()
{
  return _cinfo.angle_y;
}

inline double GTXFileInfo::GetGridAngleAroundX()
{
  return _cinfo.angle_x;
}

inline const char *GTXFileInfo::GetSampleNumberVariableName()
{
  return _cinfo.sn_var_name;
}

inline const char *GTXFileInfo::GetLineNameVariableName()
{
  return _cinfo.lname_var_name;
}

inline const char *GTXFileInfo::GetLineNumberVariableName()
{
  return _cinfo.ln_var_name;
}

inline const char *GTXFileInfo::GetRelativeNumberVariableName()
{
  return _cinfo.rn_var_name;
}

inline const char *GTXFileInfo::GetXCoordinateVariableName()
{
  return _cinfo.xg_var_name;
}

inline const char *GTXFileInfo::GetYCoordinateVariableName()
{
  return _cinfo.yg_var_name;
}

inline const char *GTXFileInfo::GetZCoordinateVariableName()
{
  return _cinfo.zg_var_name;
}

inline const char *GTXFileInfo::GetXCoreBeginVariableName()
{
  return _cinfo.xb_var_name;
}
inline const char *GTXFileInfo::GetYCoreBeginVariableName()
{
  return _cinfo.yb_var_name;
}
inline const char *GTXFileInfo::GetZCoreBeginVariableName()
{
  return _cinfo.zb_var_name;
}
inline const char *GTXFileInfo::GetXCoreEndVariableName()
{
  return _cinfo.xe_var_name;
}
inline const char *GTXFileInfo::GetYCoreEndVariableName()
{
  return _cinfo.ye_var_name;
}
inline const char *GTXFileInfo::GetZCoreEndVariableName()
{
  return _cinfo.ze_var_name;
}

#endif // __GTXFileInfo_hpp__
