#ifndef __GTXIntArray_hpp__
#define __GTXIntArray_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG

/*!
 * \brief Class for handling an array of integer
 */
class GLOBAL_CLASS GTXIntArray
{
public:
  //! empty constructor
  GTXIntArray();
  //! constructor from a count of items and a C int array
  GTXIntArray(gtx_long count, int values[]);
  //! destructor
  ~GTXIntArray();
  //! copy contructor
  GTXIntArray(const GTXIntArray &in_intarray);
#ifndef SWIG
  //! operator =
  GTXIntArray &operator=(const GTXIntArray &in_intarray);
#endif

  //! Get the number of ints in the list
  gtx_long GetCount(void) const;
  void Resize(gtx_long count);
  //! Get the rank'th int (0 <= rank < count)
  int GetValue(gtx_long rank) const;

  //! Set the rank'th int (0 <= rank < count)
  void SetValue(gtx_long rank, int value);

  //! Get the complete values array
  const int *GetValues() const;

private:
  gtx_long _count;
  int *_values;
};

#endif //__GTXIntArray_hpp__
