#ifndef __GTXStringArray_hpp__
#define __GTXStringArray_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG

/*!
 * \brief Class for handling a alphanumerical variable data
 */
class GLOBAL_CLASS GTXStringArray
{
public:
  //! empty constructor
  GTXStringArray();
  //! destructor
  ~GTXStringArray();
#ifndef SWIG
  //! constructor from a count of items and a C string array
  GTXStringArray(gtx_long count, const char * const*list);
#endif
  //! copy contructor
  GTXStringArray(const GTXStringArray &in_chrdata);
#ifndef SWIG
  //! operator =
  GTXStringArray &operator=(const GTXStringArray &in_chrdata);
#endif

  //! Get the number of values in the array
  gtx_long GetCount(void) const;
  //! Resize the array (keeps the old values when possible)
  void Resize(gtx_long count);


  //! Get the rank'th value (0 <= rank < count)
  const char *GetValue(gtx_long rank) const;
  //! Get the complete values array
  const char **GetValues() const;
  //! Set the rank'th value (0 <= rank < count)
  void SetValue(gtx_long rank, const char *value);

#ifndef SWIG
  //! Set All the Values at once (array must have been resized before)
  void SetValues(const char * const *values);
#endif

private:
  gtx_long _count;
  char **_values;
  int *_ref;
  
  //! Store values pointer as is (should not be freed by caller)
  void StorePointer(char **values, gtx_long count);
  //! Decrement ref and free it if null
  void Unref();

  friend class GTXClient;
};

#endif //__GTXStringArray_hpp__
