/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#ifndef __GTXVariableFormat_hpp__
#define __GTXVariableFormat_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG

/*!
 * \brief Class for handling Information on a file
 */
class GLOBAL_CLASS GTXVariableFormat
{
public:
  /*!< format type */
  enum FormatType
  {
    FORMAT_TYPE_DECIMAL,  //!< %%25.<B>b</B>lf
    FORMAT_TYPE_INTEGER,  //!< %%d
    FORMAT_TYPE_EXPONENT, //!< %<B>a</B>.<B>b</B>e
    FORMAT_TYPE_FREE,     //!< %<B>a</B>lg if a <= 13 & %<B>a</B>.<B>(a-7)</B>lg if a > 13
    FORMAT_TYPE_SHIFTED,  //!< %f
    FORMAT_TYPE_INVALID   //!< Invalid type
  };

  //! Default Constructor
  GTXVariableFormat();

  //! Set Format Type
  void SetType(FormatType format);
  //! Get Format Type
  FormatType GetFormatType();

  //! Set Format Length (3..19)
  void SetLength(int length);
  //! Get Format Length (3..19)
  int GetLength();

  //! Set Format Digits (0..9)
  void SetDigits(int digits);
  //! Get Format Digits (0..9)
  int GetDigits();

  //! Set Format Unit (if empty string this is a length variable)
  void SetUnit(const char *unit);
  //! Get Format Unit (if empty string this is a length variable)
  char *GetUnit();

private:
  FormatType _type;
  int _length;
  int _digits;
  char _unit[11];
  friend class GTXClient;
};

inline GTXVariableFormat::FormatType GTXVariableFormat::GetFormatType()
{
  return _type;
}

inline void GTXVariableFormat::SetType(GTXVariableFormat::FormatType type)
{
  _type = type;
}

inline int GTXVariableFormat::GetLength()
{
  return _length;
}

inline void GTXVariableFormat::SetLength(int length)
{
  _length = length;
}

inline int GTXVariableFormat::GetDigits()
{
  return _digits;
}

inline void GTXVariableFormat::SetDigits(int digits)
{
  _digits = digits;
}

inline char *GTXVariableFormat::GetUnit()
{
  return _unit;
}

inline void GTXVariableFormat::SetUnit(const char *unit)
{
  int i;
  for (i = 0; i < 10; i++)
  {
    if (unit[i] == '\0')
      break;
    _unit[i] = unit[i];
  }
  _unit[i] = '\0';
}

#endif // __GTXVariableFormat_hpp__
