/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#ifndef __GTXVariableInfo_hpp__
#define __GTXVariableInfo_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG

/*!
 * \brief Class for handling Information on a file
 */
class GLOBAL_CLASS GTXVariableInfo
{
public:
  //! empty constructor
  GTXVariableInfo();
  //! copy contructor
  GTXVariableInfo(const GTXVariableInfo &in_vinfo);

  /*!
   * \enum VariableType
   * Define the different types of variables that can be read from or written to the
   * Isatis file system.
   */
  enum VariableType
  {
    VAR_TYPE_SELECTION = -3, /*!< Only selection variables (used only for queries) */
    VAR_TYPE_FLOAT_ALL = -2, /*!< Any float variable (used only for queries) */
    VAR_TYPE_ANY       = -1, /*!< Any kind of variable (used only for queries) */
    VAR_TYPE_FLOAT,          /*!< Number variable */
    VAR_TYPE_CHAR,           /*!< String variable */
    VAR_TYPE_XG,             /*!< X coordinate variable */
    VAR_TYPE_YG,             /*!< Y coordinate variable */
    VAR_TYPE_ZG,             /*!< Z coordinate variable */
    VAR_TYPE_MACRO,          /*!< Macro variable (macro variables are always numbers */
    VAR_TYPE_INVALID         /*!< Invalid type */
  };

  //! Get variable type
  VariableType GetVariableType();
  /*! precision of the variable, can be 1, 2, 4, 8, 16, 32 or 64 bits.
   * A selection variable is also known as a 1 bit float variable
   */
  int GetBitLength();
  //! number of characters (only applicable for alphanumerical variables)
  int GetAlphaLength();
  //! Check if this variable is Implicit or not
  bool GetImplicitFlag();
  //! Get the number of variables (indices) stored in a macro variable
  int GetIndicesNumber();
  //! Get the Unit string
  const char *GetUnit();
  //! Get the Additional symbol string (used for length)
  const char *GetUnitSymbol();
  //! Check if this variable is a Length Variable or not
  bool GetLengthFlag();

private:
  GTXVariableInfo_C _cinfo;
  friend class GTXClient;
};

//! empty constructor
inline GTXVariableInfo::GTXVariableInfo()
{
}

//! copy contructor
inline GTXVariableInfo::GTXVariableInfo(const GTXVariableInfo &in_vinfo)
{
  _cinfo = in_vinfo._cinfo;
}

inline GTXVariableInfo::VariableType GTXVariableInfo::GetVariableType()
{
  return (GTXVariableInfo::VariableType)_cinfo.type;
}

inline int GTXVariableInfo::GetBitLength()
{
  return _cinfo.bit_length;
}

inline int GTXVariableInfo::GetAlphaLength()
{
  return _cinfo.alpha_length;
}

inline bool GTXVariableInfo::GetImplicitFlag()
{
  return _cinfo.implicit != 0;
}

inline int GTXVariableInfo::GetIndicesNumber()
{
  return _cinfo.i_number;
}

inline const char *GTXVariableInfo::GetUnit()
{
  return _cinfo.unit;
}

inline const char *GTXVariableInfo::GetUnitSymbol()
{
  return _cinfo.unit_symbol;
}

inline bool GTXVariableInfo::GetLengthFlag()
{
  return _cinfo.length_var != 0;
}

#endif // __GTXVariableInfo_hpp__
