/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#ifndef __GTXVendorData_hpp__
#define __GTXVendorData_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG


#include <GTXStringArray.hpp>
#include <GTXIntArray.hpp>
#include <GTXDoubleArray.hpp>


/*!
 * \brief Class for handling Vendor Data
 */
class GLOBAL_CLASS GTXVendorData
{
public:
  GTXVendorData(const char *identifier, int version);
  GTXVendorData(const GTXVendorData &vdata);
#ifndef SWIG
  GTXVendorData operator=(const GTXVendorData &vdata);
#endif
   ~GTXVendorData(); 
  

  void AddAttributeInt(const char *name, int value);
  void AddAttributeDouble(const char *name, double value);
  void AddAttributeString(const char *name, const char *value);
  void AddAttributeIntArray(const char *name, const GTXIntArray &values);
  void AddAttributeDoubleArray(const char *name, const GTXDoubleArray &values);
  void AddAttributeStringArray(const char *name, const GTXStringArray &values);
  
  int GetVersion() const;
  const char *GetIdentifier() const;

  int GetAttributeInt(const char *name) const;
  double GetAttributeDouble(const char *name) const;
  const char* GetAttributeString(const char *name) const;
  GTXIntArray    GetAttributeIntArray(const char *name) const;
  GTXDoubleArray GetAttributeDoubleArray(const char *name) const;
  GTXStringArray  GetAttributeStringArray(const char *name) const;
  
 




private:
  GTXVendorData_C _vdata;

  friend class GTXClient;
};

#endif // __GTXVendorData_hpp__
