/*****************************************************************************
 
            Copyright (c)2009 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#ifndef __GTXWireframe_hpp__
#define __GTXWireframe_hpp__

#define __USING_GTXSERVER_CPP_API__

#ifdef DOXYGEN
#define SWIG_OR_DOXYGEN
#endif //DOXYGEN

#ifdef SWIG
#define GLOBAL_CLASS
#define SWIG_OR_DOXYGEN
#else //SWIG
#include <GTXClient.h>
#endif //SWIG

#include <GTXWireframeObject.hpp>

/*!
 * \brief Class for handling individual Wireframes
 */
class GLOBAL_CLASS GTXWireframe
{
public:
  GTXWireframe();
  GTXWireframe(const GTXWireframe &wireframe);
#ifndef SWIG
  GTXWireframe operator=(const GTXWireframe &wireframe);
#endif
  ~GTXWireframe();
  
  const char* GetName()const;
  int GetColorR()const;
  int GetColorG()const;
  int GetColorB()const;
  int GetObjectsNumber()const;
  // named like this because of Windows include which redefine GetObject
  GTXWireframeObject GetWireframeObject(int rank)const;

  void SetName(const char *name);
  void SetColorRGB(int r, int g, int b);

  void AddObject(const GTXWireframeObject &object);

private:
  GTXWireframe_C _wireframe;

  friend class GTXClient;
  friend class GTXWireframeSystem;
};

#endif // __GTXWireframe_hpp__
