#include <GTXByteArray.hpp>

GTXByteArray::GTXByteArray()
{
  _count = 0;
  _values = (unsigned char*)0;
}
/*!
****************************************************************************
\param count number of values
\param values array of values to be copied
***************************************************************************/
GTXByteArray::GTXByteArray(gtx_long count, unsigned char values[])
{
  _count = count;
  _values = new unsigned char[_count];
  for (gtx_long i = 0; i < _count; i++)
    _values[i] = values[i];
}
/*!
****************************************************************************
\param in_bytearray source byte array
***************************************************************************/
GTXByteArray::GTXByteArray(const GTXByteArray &in_bytearray)
{
  _count = in_bytearray._count;
  _values = (unsigned char*)0;
  if (_count != 0)
  {
    _values = new unsigned char[_count];
    for (gtx_long i = 0; i < _count; i++)
      _values[i] = in_bytearray._values[i];
  }
}

/*!
****************************************************************************
\param in_bytearray source byte array
***************************************************************************/
GTXByteArray &GTXByteArray::operator=(const GTXByteArray &in_bytearray)
{
  _count = in_bytearray._count;
  _values = (unsigned char*)0;
  if (_count != 0)
  {
    _values = new unsigned char[_count];
    for (gtx_long i = 0; i < _count; i++)
      _values[i] = in_bytearray._values[i];
  }
  return *this;
}

GTXByteArray::~GTXByteArray()
{
  if (_values == 0) return;
  delete _values;
  _values = 0;
  _count = 0;
}

/*!
****************************************************************************
\return number of values in the array
***************************************************************************/
gtx_long GTXByteArray::GetCount() const
{
  return (_count);
}

/*!
****************************************************************************
\param count number of values
***************************************************************************/
void GTXByteArray::Resize(gtx_long count)
{
  unsigned char *vals2;
  gtx_long min_cnt = (count < _count)? count: _count;

  vals2 = new unsigned char[count];
  for (gtx_long i = 0; i < min_cnt; i++)
    vals2[i] = _values[i];
  for (gtx_long i = min_cnt; i < count; i++)
    vals2[i] = 0;

  if (_values != 0)
    delete _values;
  _values = vals2;
  _count = count;
}

/*!
****************************************************************************
\param rank (0 <= rank < count) of the value to retrieve

\return rank'th int value
***************************************************************************/
unsigned char GTXByteArray::GetValue(gtx_long rank) const
{
  return (rank >= 0 && rank < _count? _values[rank]: -1);
}

/*!
****************************************************************************
\param rank (0 <= rank < count) of the value to change
\param value new rank'th int value
***************************************************************************/
void GTXByteArray::SetValue(gtx_long rank, unsigned char value)
{
  if (rank >= 0 && rank < _count)
    _values[rank] = value;
}

/*!
****************************************************************************
\return the pointer on the array used in the internal structure
\par Remarks
in C# and Java, this is changed to a copy as a native byte array
***************************************************************************/
const unsigned char *GTXByteArray::GetValues() const
{
  return _values;
}
