#include <GTXCharData.hpp>
#include <GTXClientP.h>         // for strdup and NULL

GTXCharData::GTXCharData(gtx_long count, const char*const *list)
  :GTXStringArray( count,list)
{
  _undef_val = NULL;
}

GTXCharData::GTXCharData()
  :GTXStringArray()
{
  _undef_val = NULL;
}

GTXCharData::GTXCharData(const GTXCharData &in_chrdata)
  :GTXStringArray( in_chrdata)
{
  _undef_val = NULL;
  if (in_chrdata._undef_val != NULL)
    _undef_val = (char*)strdup(in_chrdata._undef_val);
}

GTXCharData &GTXCharData::operator=(const GTXCharData &in_chrdata)
{
  GTXStringArray::operator=(in_chrdata);
  _undef_val = NULL;
  if (in_chrdata._undef_val != NULL)
    _undef_val = (char*)strdup(in_chrdata._undef_val);
  return (*this);
}

GTXCharData::~GTXCharData()
{
  if (_undef_val != 0)
    free(_undef_val);
  _undef_val = NULL;
}



const char *GTXCharData::GetUndefinedValue() const
{
  return (_undef_val == NULL)? "": _undef_val;
}

void GTXCharData::SetUndefinedValue(const char *undef_val)
{
  if (_undef_val != NULL)
    free(_undef_val);
  _undef_val = strdup(undef_val);
}
