#include <GTXDoubleData.hpp>
#include <stdlib.h>
/*!
****************************************************************************
\param count number of values
\param values array of values to be copied
***************************************************************************/
GTXDoubleData::GTXDoubleData(gtx_long count, double values[])
  : GTXDoubleArray(count, values)
{
  _undef_val = -999999;

}

GTXDoubleData::GTXDoubleData()
  : GTXDoubleArray()
{
  _undef_val = -999999;
}

GTXDoubleData::GTXDoubleData(const GTXDoubleData &in_dbldata)
  : GTXDoubleArray(in_dbldata)
{
  _undef_val = in_dbldata._undef_val;
}

GTXDoubleData &GTXDoubleData::operator=(const GTXDoubleData &in_dbldata)
{
  GTXDoubleArray::operator=(in_dbldata);
  _undef_val = in_dbldata._undef_val;
  return *this;
}

GTXDoubleData::~GTXDoubleData()
{
}


double GTXDoubleData::GetUndefinedValue() const
{
  return _undef_val;
}

void GTXDoubleData::SetUndefinedValue(double undef_val)
{
  _undef_val = undef_val;
}
