#include <GTXError.hpp>
#include <string.h>
#include <stdlib.h>

/****************************************************************************/
/*!
 * Constructor from a char string
 *
 * \param[in] message Initial value for the message associated to the exception
 *
 ****************************************************************************/
GTXError::GTXError(const char *message)
{
  _buffer = (char*)malloc(strlen(message)+1);
  (void)strcpy(_buffer, message);
}

/****************************************************************************/
/*!
 * Copy Constructor
 *
 * \param[in]  in_exception Input exception
 *
 ****************************************************************************/
GTXError::GTXError(const GTXError & in_exception)
{
  _buffer = (char*)malloc(strlen(in_exception._buffer)+1);
  (void)strcpy(_buffer, in_exception._buffer);
}

/****************************************************************************/
/*!
 * Destructor
 *
 ****************************************************************************/
GTXError::~GTXError()
{
  free(_buffer);
}

const char *GTXError::GetMessage()
{
  return _buffer;
}
