#include <GTXFault.hpp>
#include <GTXFaultInfo.hpp>
#include <GTXClientP.h>
#include <GTXClient.hpp>
#include <GTXError.hpp>

/*!
******************************************************************************
\brief Empty Constructor
*****************************************************************************/
GTXFault::GTXFault()
{
  _fault = new GTXFault_C;
  _fault->name[0] = '\0';
  _fault->polygon = 0;
  _fault->n_segments = 0;
  _fault->segments = NULL;
}
/*!
******************************************************************************
\brief Copy Constructor
*****************************************************************************/
GTXFault::GTXFault(const GTXFault &fault)
{
  _fault = new GTXFault_C;
  GTXClientFaultDuplicate(fault._fault, _fault);
}
/*!
******************************************************************************
\brief Operator equals
*****************************************************************************/
GTXFault GTXFault::operator=(const GTXFault &fault)
{
  if (_fault->segments != NULL)
    free(_fault->segments);
  delete _fault;
  _fault = new GTXFault_C;
  GTXClientFaultDuplicate(fault._fault, _fault);
  return *this;
}
/*!
******************************************************************************
\brief Destructor
*****************************************************************************/
GTXFault::~GTXFault()
{
    free(_fault->segments);
    delete _fault;
}


/*!
******************************************************************************
\brief Get value from name attribute of a Fault
 
This function reads the value from name attribute of a FaultSystem
\return Returned name
*****************************************************************************/
const char * GTXFault::GetName() const
{
  return _fault->name;
}
/*!
******************************************************************************
\brief Get value from polygon attribute of a Fault
 
This function reads the value from polygon attribute of a FaultSystem
\return Returned polygon
*****************************************************************************/
bool GTXFault::GetPolygonalFlag() const
{
  bool tmp = false;
  if(_fault->polygon)
    tmp = true;
  return tmp;

}
/*!
******************************************************************************
\brief Get value from NSegments attribute of a Fault
 
This function reads the value from NSegments attribute of a FaultSystem
\return Returned NSegment
*****************************************************************************/
int GTXFault::GetSegmentsNumber() const
{
  return _fault->n_segments;
}
/*!
******************************************************************************
\brief Get value from Segment attribute of a Fault
 
This function reads the value from Segment attribute of a FaultSystem
\return Returned Segment
\param rank The Rank of the Segment
*****************************************************************************/
const GTXFaultSegment GTXFault::GetSegment(int rank) const
{
  if((rank<0)||(rank>GetSegmentsNumber()-1))
    throw GTXError("GTXFault::GetSegment :Rank should be between 0 and Segments Number");
  GTXFaultSegment tmp;
  GTXClientFaultsSegmentDuplicate(&_fault->segments[rank], tmp._fseg); 
  return tmp; 
}
/*!
******************************************************************************
\brief Set Name attribute to a Fault 
 
This function set Name attribute to a Fault 
\param name Attribute name
*****************************************************************************/
void GTXFault::SetName(const char * name) 
{
  strcpy(_fault->name, name);
}
/*!
******************************************************************************
\brief Set polygon attribute to a Fault 
 
This function set polygon attribute to a Fault 
\param poly Attribute polygon
*****************************************************************************/
void GTXFault::SetPolygonalFlag(bool poly) 
{
  if(poly)
    _fault->polygon = 1;
  else
    _fault->polygon = 0;

}
/*!
******************************************************************************
\brief add a fault segment to a Fault 
 
This function add a Fault Segment to a Fault 
\param fseg The fault segment whitch is add.
*****************************************************************************/
void GTXFault::AddFaultSegment(const GTXFaultSegment &fseg) 
{
  _fault->segments = (GTXFaultSegment_C *)
    realloc(_fault->segments, sizeof(GTXFaultSegment_C)*(_fault->n_segments+1));
  GTXClientFaultsSegmentDuplicate(fseg._fseg, &_fault->segments[_fault->n_segments] );
  _fault->n_segments++;
}

