#include <GTXFaultSegment.hpp>
#include <GTXFaultInfo.hpp>
#include <GTXClientP.h>
#include <GTXClient.hpp>

/*!
******************************************************************************
\brief Empty Constructor
*****************************************************************************/
GTXFaultSegment::GTXFaultSegment()
{
   _fseg = new GTXFaultSegment_C;
  _fseg->X1 = 0.;
  _fseg->Y1 = 0.;
  _fseg->Z1 = 0.;
  _fseg->X2 = 0.;
  _fseg->Y2 = 0.;
  _fseg->Z2 = 0.;
  _fseg->X3 = 0.;
  _fseg->Y3 = 0.;
  _fseg->Z3 = 0.;
  _fseg->V1 = 0.;
  _fseg->V2 = 0.;
  _fseg->V3 = 0.;
  _fseg->priority = 0;
}

/*!
******************************************************************************
\brief Copy Constructor
*****************************************************************************/
GTXFaultSegment::GTXFaultSegment(const GTXFaultSegment &fseg)
{
  _fseg = new GTXFaultSegment_C;
  GTXClientFaultsSegmentDuplicate(fseg._fseg, _fseg);
}
/*!
******************************************************************************
\brief Operator equals
*****************************************************************************/
GTXFaultSegment GTXFaultSegment::operator=(const GTXFaultSegment &fseg)
{
  GTXClientFaultsSegmentDuplicate(fseg._fseg, _fseg);
  return *this;
}

/*!
******************************************************************************
\brief Destructor
*****************************************************************************/
GTXFaultSegment::~GTXFaultSegment()
{
  delete _fseg;
}

/*!
******************************************************************************
\brief Get value from X1 attribute of a Fault Segment
 
This function reads the value from X1 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetX1()const
{
  return _fseg->X1;
}

/*!
******************************************************************************
\brief Get value from Y1 attribute of a Fault Segment
 
This function reads the value from Y1 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetY1()const
{
  return _fseg->Y1;
}

/*!
******************************************************************************
\brief Get value from Z1 attribute of a Fault Segment
 
This function reads the value from Z1 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetZ1()const
{
  return _fseg->Z1;
}

/*!
******************************************************************************
\brief Get value from X2 attribute of a Fault Segment
 
This function reads the value from X2 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetX2()const
{
  return _fseg->X2;
}

/*!
******************************************************************************
\brief Get value from Y2 attribute of a Fault Segment
 
This function reads the value from Y2 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetY2()const
{
  return _fseg->Y2;
}

/*!
******************************************************************************
\brief Get value from Z2 attribute of a Fault Segment
 
This function reads the value from Z2 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetZ2()const
{
  return _fseg->Z2;
}
/*!
******************************************************************************
\brief Get value from X3 attribute of a Fault Segment
 
This function reads the value from X3 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetX3()const
{
  return _fseg->X3;
}
/*!
******************************************************************************
\brief Get value from Y3 attribute of a Fault Segment
 
This function reads the value from Y3 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetY3()const
{
  return _fseg->Y3;
}
/*!
******************************************************************************
\brief Get value from Z3 attribute of a Fault Segment
 
This function reads the value from Z3 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetZ3()const
{
  return _fseg->Z3;
}

/*!
******************************************************************************
\brief Get value from V1 attribute of a Fault Segment
 
This function reads the value from V1 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetV1()const
{
  return _fseg->V1;
}
/*!
******************************************************************************
\brief Get value from V2 attribute of a Fault Segment
 
This function reads the value from V2 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetV2()const
{
  return _fseg->V2;
}
/*!
******************************************************************************
\brief Get value from V3 attribute of a Fault Segment
 
This function reads the value from V3 attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
double GTXFaultSegment::GetV3()const
{
  return _fseg->V3;
}
/*!
******************************************************************************
\brief Get value from priority attribute of a Fault Segment
 
This function reads the value from priority attribute of a Fault Segment
\return Returned double value
*****************************************************************************/
int GTXFaultSegment::GetPriority()const
{
  return _fseg->priority;
}

/*!
******************************************************************************
\brief Set X1 attribute to a Fault Segment
 
This function set X1 attribute to a Fault Segment
\param X1 Attribute X1
*****************************************************************************/
void GTXFaultSegment::SetX1(double X1)
{
  _fseg->X1 = X1;
}
/*!
******************************************************************************
\brief Set Y1 attribute to a Fault Segment
 
This function set Y1 attribute to a Fault Segment
\param Y1 Attribute Y1
*****************************************************************************/
void GTXFaultSegment::SetY1(double Y1)
{
  _fseg->Y1 = Y1;
}
/*!
******************************************************************************
\brief Set Z1 attribute to a Fault Segment
 
This function set Z1 attribute to a Fault Segment
\param Z1 Attribute Z1
*****************************************************************************/
void GTXFaultSegment::SetZ1(double Z1)
{
  _fseg->Z1 = Z1;
}
/*!
******************************************************************************
\brief Set X2 attribute to a Fault Segment
 
This function set X2 attribute to a Fault Segment
\param X2 Attribute X2
*****************************************************************************/
void GTXFaultSegment::SetX2(double X2)
{
  _fseg->X2 = X2;
}
/*!
******************************************************************************
\brief Set Y2 attribute to a Fault Segment
 
This function set Y2 attribute to a Fault Segment
\param Y2 Attribute Y2
*****************************************************************************/
void GTXFaultSegment::SetY2(double Y2)
{
  _fseg->Y2 = Y2;
}
/*!
******************************************************************************
\brief Set Z2 attribute to a Fault Segment
 
This function set Z2 attribute to a Fault Segment
\param Z2 Attribute Z2
*****************************************************************************/
void GTXFaultSegment::SetZ2(double Z2)
{
  _fseg->Z2 = Z2;
}
/*!
******************************************************************************
\brief Set X3 attribute to a Fault Segment
 
This function set X3 attribute to a Fault Segment
\param X3 Attribute X3
*****************************************************************************/
void GTXFaultSegment::SetX3(double X3)
{
  _fseg->X3 = X3;
}
/*!
******************************************************************************
\brief Set Y3 attribute to a Fault Segment
 
This function set Y3 attribute to a Fault Segment
\param Y3 Attribute Y3
*****************************************************************************/
void GTXFaultSegment::SetY3(double Y3)
{
  _fseg->Y3 = Y3;
}
/*!
******************************************************************************
\brief Set Z3 attribute to a Fault Segment
 
This function set Z3 attribute to a Fault Segment
\param Z3 Attribute Z3
*****************************************************************************/
void GTXFaultSegment::SetZ3(double Z3)
{
  _fseg->Z3 = Z3;
}
/*!
******************************************************************************
\brief Set V1 attribute to a Fault Segment
 
This function set V1 attribute to a Fault Segment
\param V1 Attribute V1
*****************************************************************************/
void GTXFaultSegment::SetV1(double V1)
{
  _fseg->V1 = V1;
}
/*!
******************************************************************************
\brief Set V2 attribute to a Fault Segment
 
This function set V2 attribute to a Fault Segment
\param V2 Attribute V2
*****************************************************************************/
void GTXFaultSegment::SetV2(double V2)
{
  _fseg->V2 = V2;
}
/*!
******************************************************************************
\brief Set V3 attribute to a Fault Segment
 
This function set V3 attribute to a Fault Segment
\param V3 Attribute V3
*****************************************************************************/
void GTXFaultSegment::SetV3(double V3)
{
  _fseg->V3 = V3;
}
/*!
******************************************************************************
\brief Set priority attribute to a Fault Segment
 
This function set priority attribute to a Fault Segment
\param priority Attribute priority
*****************************************************************************/
void GTXFaultSegment::SetPriority(int priority)
{
  _fseg->priority = priority;
}

