#include <GTXFault.hpp>
#include <GTXFaultSystem.hpp>
#include <GTXFaultInfo.hpp>
#include <GTXClientP.h>
#include <GTXClient.hpp>
#include <GTXError.hpp>


/*!
******************************************************************************
\brief Empty Constructor
*****************************************************************************/
GTXFaultSystem::GTXFaultSystem()
{
  _fsys =  new GTXFaultSystem_C;
  _fsys->faults_2d = 0;
  _fsys->aux_var_used = 0;
  _fsys->aux_var_test = -9999.;
  _fsys->n_faults = 0;
  _fsys->faults = NULL;
}

/*!
******************************************************************************
\brief Copy Constructor
*****************************************************************************/
GTXFaultSystem::GTXFaultSystem(const GTXFaultSystem &fsys)
{
  _fsys = GTXClientFaultSystemDuplicate(fsys._fsys);
}

/*!
******************************************************************************
\brief Operator equals
*****************************************************************************/
GTXFaultSystem GTXFaultSystem::operator=(const GTXFaultSystem &fsys)
{
  GTXClientFreeFaults(this->_fsys);
  delete _fsys;
  _fsys = GTXClientFaultSystemDuplicate(fsys._fsys);
  return *this;
}

/*!
******************************************************************************
\brief Desstructor
*****************************************************************************/
GTXFaultSystem::~GTXFaultSystem()
{
  GTXClientFreeFaults(_fsys);
  delete _fsys;
}
/*!
******************************************************************************
\brief Get value from faults2D attribute of a FaultSystem 
 
This function reads the value from faults2D attribute of a FaultSystem
\return Returned faults2D
*****************************************************************************/
bool GTXFaultSystem::GetFaults2DFlag() const
{
  bool tmp = false;
  if(_fsys->faults_2d)
    tmp = true;
  return tmp;
}
/*!
******************************************************************************
\brief Get value from AuxVarUsed attribute of a FaultSystem 
 
This function reads the value from AuxVarUsed attribute of a FaultSystem
\return Returned AuxVarUsed
*****************************************************************************/
bool GTXFaultSystem::GetAuxiliaryVarUsedFlag() const
{
  bool tmp = false;
  if(_fsys->aux_var_used)
    tmp = true;
  return tmp;
}
/*!
******************************************************************************
\brief Get value from AuxVarTest attribute of a FaultSystem 
 
This function reads the value from AuxVarTest attribute of a FaultSystem
\return Returned AuxVarTest
*****************************************************************************/
double GTXFaultSystem::GetAuxiliaryVarTest() const
{
  return _fsys->aux_var_test;
}
/*!
******************************************************************************
\brief Get value from Nfaults attribute of a FaultSystem 
 
This function reads the value from Nfaults attribute of a FaultSystem
\return Returned Nfaults
*****************************************************************************/
int GTXFaultSystem::GetFaultsNumber() const
{
  return _fsys->n_faults;
}

/*!
******************************************************************************
\brief Get value from faults attribute of a FaultSystem 
 
This function reads the value from faults attribute of a FaultSystem
\param rank Rank of the Fault
\return Returned faults
*****************************************************************************/
GTXFault GTXFaultSystem::GetFault(int rank)const
{
  if((rank<0)||(rank>GetFaultsNumber()-1))
    throw GTXError("GTXFaultSystem::GetFault :Rank should be between 0 and Faults Number");
  GTXFault tmp;
  GTXClientFaultDuplicate(&_fsys->faults[rank], tmp._fault); 
  return tmp;
}

/*!
******************************************************************************
\brief Set Faults2D attribute to a Fault System
 
This function set Faults2D  attribute to a Fault System
\param value Attribute Faults2D
*****************************************************************************/
void GTXFaultSystem::SetFaults2DFlag(bool value)
{
  if(value)
    _fsys->faults_2d = 1;
  else
      _fsys->faults_2d = 0;
}
/*!
******************************************************************************
\brief Set AuxVarUsed attribute to a Fault System
 
This function set AuxVarUsed attribute to a Fault System
\param avu Attribute AuxVarUsed
*****************************************************************************/
void GTXFaultSystem::SetAuxiliaryVarUsedFlag(bool avu)
{
  if(avu)
    _fsys->aux_var_used = 1;
  else
    _fsys->aux_var_used = 0;
}
/*!
******************************************************************************
\brief Set AuxVarTest attribute to a Fault System
 
This function set AuxVarTest attribute to a Fault System
\param avt Attribute AuxVarTest
*****************************************************************************/
void GTXFaultSystem::SetAuxiliaryVarTest(double avt)
{
  _fsys->aux_var_test= avt;
}
/*!
******************************************************************************
\brief add a fault to a Fault System
 
This function add a Fault to a Fault System
\param fault The fault whitch is add.
*****************************************************************************/
void GTXFaultSystem::AddFault(const GTXFault &fault)
{
  _fsys->faults = (GTXFault_C*)
    realloc(_fsys->faults, sizeof(GTXFault_C)*(_fsys->n_faults+1));
  GTXClientFaultDuplicate(fault._fault ,&_fsys->faults[_fsys->n_faults] );
  _fsys->n_faults++;
}

