#include <GTXIntArray.hpp>

GTXIntArray::GTXIntArray()
{
  _count = 0;
  _values = (int*)0;
}
/*!
****************************************************************************
\param count number of values
\param values array of values to be copied
***************************************************************************/
GTXIntArray::GTXIntArray(gtx_long count, int values[])
{
  _count = count;
  _values = new int[_count];
  for (gtx_long i = 0; i < _count; i++)
    _values[i] = values[i];
}
/*!
****************************************************************************
\param in_intarray source int array
***************************************************************************/
GTXIntArray::GTXIntArray(const GTXIntArray &in_intarray)
{
  _count = in_intarray._count;
  _values = (int*)0;
  if (_count != 0)
  {
    _values = new int[_count];
    for (gtx_long i = 0; i < _count; i++)
      _values[i] = in_intarray._values[i];
  }
}

/*!
****************************************************************************
\param in_intarray source int array
***************************************************************************/
GTXIntArray &GTXIntArray::operator=(const GTXIntArray &in_intarray)
{
  _count = in_intarray._count;
  _values = (int*)0;
  if (_count != 0)
  {
    _values = new int[_count];
    for (gtx_long i = 0; i < _count; i++)
      _values[i] = in_intarray._values[i];
  }
  return *this;
}

GTXIntArray::~GTXIntArray()
{
  if (_values == 0) return;
  delete _values;
  _values = 0;
  _count = 0;
}

/*!
****************************************************************************
\return number of values in the array
***************************************************************************/
gtx_long GTXIntArray::GetCount() const
{
  return (_count);
}

/*!
****************************************************************************
\param count number of values
***************************************************************************/
void GTXIntArray::Resize(gtx_long count)
{
  int *vals2;
  gtx_long min_cnt = (count < _count)? count: _count;

  vals2 = new int[count];
  for (gtx_long i = 0; i < min_cnt; i++)
    vals2[i] = _values[i];
  for (gtx_long i = min_cnt; i < count; i++)
    vals2[i] = 0;

  if (_values != 0)
    delete _values;
  _values = vals2;
  _count = count;
}

/*!
****************************************************************************
\param rank (0 <= rank < count) of the value to retrieve

\return rank'th int value
***************************************************************************/
int GTXIntArray::GetValue(gtx_long rank) const
{
  return (rank >= 0 && rank < _count? _values[rank]: -1);
}

/*!
****************************************************************************
\param rank (0 <= rank < count) of the value to change
\param value new rank'th int value
***************************************************************************/
void GTXIntArray::SetValue(gtx_long rank, int value)
{
  if (rank >= 0 && rank < _count)
    _values[rank] = value;
}

/*!
****************************************************************************
\return the pointer on the array used in the internal structure
\par Remarks
in C# and Java, this is changed to a copy as a native int array
***************************************************************************/
const int *GTXIntArray::GetValues() const
{
  return _values;
}
