#include <GTXPolygon.hpp>
#include <GTXClientP.h>
#include <GTXClient.hpp>
/*!
******************************************************************************
\brief Empty Constructor
*****************************************************************************/
GTXPolygon::GTXPolygon()
{
  (void)strcpy(_poly.name, "");
  (void)strcpy(_poly.group_name, "");
  _poly.n_vertices = 0;  
  _poly.vertices = (double*)0;
}

/*!
******************************************************************************
\brief Copy Constructor
*****************************************************************************/
GTXPolygon::GTXPolygon(const GTXPolygon &poly)
{
  GTXClientPolygonDuplicate(&poly._poly, &_poly);
}

/*!
******************************************************************************
\brief Operator equals
*****************************************************************************/
GTXPolygon GTXPolygon::operator=(const GTXPolygon &poly)
{
  _poly.vertices = (double*)GTXClientFreePointer(_poly.vertices);
  GTXClientPolygonDuplicate(&poly._poly, &_poly);
  return *this;
}

/*!
******************************************************************************
\brief Destructor
*****************************************************************************/
GTXPolygon::~GTXPolygon()
{
  _poly.vertices = (double*)GTXClientFreePointer(_poly.vertices);
}
/*!
******************************************************************************
\brief Get value from name attribute of a Polygon

This function reads the value from name attribute of a Polygon
\return Return name
*****************************************************************************/
const char* GTXPolygon::GetName()const
{
  return _poly.name;
}
/*!
******************************************************************************
\brief Get value from group_name attribute of a Polygon

This function reads the value from group_name attribute of a Polygon
\return Return group_name
*****************************************************************************/
const char* GTXPolygon::GetGroupName()const
{
  return _poly.group_name;
}
/*!
******************************************************************************
\brief Get value from z_min attribute of a Polygon

This function reads the value from z_min attribute of a Polygon
\return Return z_min
*****************************************************************************/
double GTXPolygon::GetZMin()const
{
  return _poly.z_min;
}
/*!
******************************************************************************
\brief Get value from z_max attribute of a Polygon

This function reads the value from z_max attribute of a Polygon
\return Return z_max
*****************************************************************************/
double GTXPolygon::GetZMax()const
{
  return _poly.z_max;
}
/*!
******************************************************************************
\brief Get value from n_vertices attribute of a Polygon

This function reads the value from n_vertices attribute of a Polygon
\return Return n_vertices
*****************************************************************************/
int  GTXPolygon::GetVerticesNumber()const 
{
  return _poly.n_vertices;
}
/*!
******************************************************************************
\brief Get value from Xvertices attribute of a Polygon

This function reads the value from Xvertices attribute of a Polygon
\return Return Xvertices
*****************************************************************************/
double GTXPolygon::GetXVertices(int rank)const 
{
  return _poly.vertices[2*rank];
}
/*!
******************************************************************************
\brief Get value from Yvertices attribute of a Polygon

This function reads the value from Yvertices attribute of a Polygon
\return Return Yvertices
*****************************************************************************/
double GTXPolygon::GetYVertices(int rank)const 
{
  return _poly.vertices[2*rank+1];
}


/*!
******************************************************************************
\brief Set value from name attribute of a Polygon

This function changes the value from name attribute of a Polygon
\param name name
*****************************************************************************/
void GTXPolygon::SetName(const char * name)
{
  strcpy(_poly.name, name);
}
/*!
******************************************************************************
\brief Set value from group_name attribute of a Polygon

This function changes the value from group_name attribute of a Polygon
\param group_name group_name
*****************************************************************************/
void GTXPolygon::SetGroupName(const char * group_name)
{
  strcpy(_poly.group_name, group_name);
}
/*!
******************************************************************************
\brief Set value from ZMin attribute of a Polygon

This function changes the value from ZMin attribute of a Polygon
\param z_min ZMin
*****************************************************************************/
void GTXPolygon::SetZMin(double z_min)
{
  _poly.z_min = z_min;
}
/*!
******************************************************************************
\brief Set value from ZMax attribute of a Polygon

This function changes the value from ZMax attribute of a Polygon
\param z_max ZMax
*****************************************************************************/
void GTXPolygon::SetZMax(double z_max)
{
  _poly.z_max = z_max;
}
/*!
******************************************************************************
\brief add value vertices of a Polygon

This function add veritives of a Polygon
\param x, y vertex position
\par Remarks:
All coordinates are returned in the current unit (\ref GTXClient::SetUnit) or
using the corresponding coordinate variable unit if unit_mode is set to 1
(\ref GTXClient::SetUnitMode).
*****************************************************************************/
void GTXPolygon::AddVertex(double x, double y)
{
  _poly.n_vertices++;
  _poly.vertices =(double *) realloc(_poly.vertices, 2 * _poly.n_vertices * sizeof(double));
  _poly.vertices[2*_poly.n_vertices-2] = x;
  _poly.vertices[2*_poly.n_vertices-1] = y;
}

