#include <GTXPolygonSystem.hpp>
#include <GTXClientP.h>
#include <GTXClient.hpp>
#include <GTXError.hpp>
/*!
******************************************************************************
\brief Empty Constructor
*****************************************************************************/
GTXPolygonSystem::GTXPolygonSystem()
{
  _polysys.n_polygons = 0;
  _polysys.polygons = (GTXPolygon_C*)0;
  _polysys.ext_min[0] = 0.;
  _polysys.ext_min[1] = 0.;
  _polysys.ext_min[2] = 0.;
  _polysys.ext_max[0] = 0.;
  _polysys.ext_max[1] = 0.;
  _polysys.ext_max[2] = 0.;
}

/*!
******************************************************************************
\brief Copy Constructor
*****************************************************************************/
GTXPolygonSystem::GTXPolygonSystem(const GTXPolygonSystem &polysys)
{
  GTXClientPolygonSystemDuplicate(&polysys._polysys, &_polysys);
}

/*!
******************************************************************************
\brief Operator equals
*****************************************************************************/
GTXPolygonSystem GTXPolygonSystem::operator=(const GTXPolygonSystem &polysys)
{
  GTXClientFreePolygons(&_polysys);
  GTXClientPolygonSystemDuplicate(&polysys._polysys, &_polysys);
  return *this;
}

/*!
******************************************************************************
\brief Destructor
*****************************************************************************/
GTXPolygonSystem::~GTXPolygonSystem()
{
  GTXClientFreePolygons(&_polysys);
}

/*!
******************************************************************************
\brief Get flag from Polygones2D attribute of a Polygon System

This function reads the flag from Polygones2D attribute of a Polygon System
\return Return Polygons2DFlag
*****************************************************************************/
bool GTXPolygonSystem::GetPolygons2DFlag()const 
{
  bool tmp = false;
  if(_polysys.polygons_2d)
    tmp = true;
  return tmp;
}
/*!
******************************************************************************
\brief Get value from MinimumExtensionX attribute of a Polygon System

This function reads the value from MinimumExtensionX attribute of a Polygon System
\return Return MinimumExtensionX
*****************************************************************************/
double GTXPolygonSystem::GetMinimumExtensionX()const 
{
  return  _polysys.ext_min[0];
}
/*!
******************************************************************************
\brief Get value from MinimumExtensionY attribute of a Polygon System

This function reads the value from MinimumExtensionY attribute of a Polygon System
\return Return MinimumExtensionY
*****************************************************************************/
double GTXPolygonSystem::GetMinimumExtensionY()const 
{
  return  _polysys.ext_min[1];
}
/*!
******************************************************************************
\brief Get value from MinimumExtensionZ attribute of a Polygon System

This function reads the value from MinimumExtensionZ attribute of a Polygon System
\return Return MinimumExtensionZ
*****************************************************************************/
double GTXPolygonSystem::GetMinimumExtensionZ()const 
{
  return  _polysys.ext_min[2];
}
/*!
******************************************************************************
\brief Get value from MaximumExtensionX attribute of a Polygon System

This function reads the value from MaximumExtensionX attribute of a Polygon System
\return Return MaximumExtensionX
*****************************************************************************/
double GTXPolygonSystem::GetMaximumExtensionX()const 
{
  return  _polysys.ext_max[0];
}
/*!
******************************************************************************
\brief Get value from MaximumExtensionY attribute of a Polygon System

This function reads the value from MaximumExtensionY attribute of a Polygon System
\return Return MaximumExtensionZ
*****************************************************************************/
double GTXPolygonSystem::GetMaximumExtensionY()const 
{
  return  _polysys.ext_max[1];
}
/*!
******************************************************************************
\brief Get value from MaximumExtensionZ attribute of a Polygon System

This function reads the value from MaximumExtensionZ attribute of a Polygon System
\return Return MaximumExtensionZ
*****************************************************************************/
double GTXPolygonSystem::GetMaximumExtensionZ()const 
{
  return  _polysys.ext_max[2];
}
/*!
******************************************************************************
\brief Get value from Polygons Number attribute of a Polygon System

This function reads the value from Polygons Number attribute of a Polygon System
\return Return Polygons Number
*****************************************************************************/
gtx_long GTXPolygonSystem::GetPolygonsNumber()const 
{
  return _polysys.n_polygons;
}
/*!
******************************************************************************
\brief Get value from Polygons attribute of a Polygon System

This function reads the value from Polygons attribute of a Polygon System
\return Return Polygons
\param rank Rank of the polygon
\throw GTXError
*****************************************************************************/
GTXPolygon GTXPolygonSystem::GetPolygon(int rank)const 
{
  if((rank<0)||(rank>GetPolygonsNumber()-1))
    throw GTXError("GTXPolygonSystem::GetPolygon:Rank should be between 0 and Polygon Number");
  GTXPolygon tmp;
  GTXClientPolygonDuplicate(&_polysys.polygons[rank], &tmp._poly);
  return tmp;
}

/*!
******************************************************************************
\brief Set flag from Polygons2D attribute of a Polygon System

This function changes the flag from Polygons2D attribute of a Polygon System
\param flag true to make polygons 2D, false to make them 3D (2D polygon + thickness)
*****************************************************************************/
void GTXPolygonSystem::SetPolygons2DFlag(bool flag)
{
  if(flag)
    _polysys.polygons_2d = 1;
  else
    _polysys.polygons_2d = 0;
}

/*!
******************************************************************************
\brief add  Polygon for a Polygon System

This function add Polygon of a Polygon System
\param poly Polygon
*****************************************************************************/
void GTXPolygonSystem::AddPolygon(const GTXPolygon &poly)
{
  _polysys.n_polygons++;
  _polysys.polygons =(GTXPolygon_C *) realloc(_polysys.polygons,_polysys.n_polygons * sizeof(GTXPolygon_C));
  GTXClientPolygonDuplicate(&poly._poly,&_polysys.polygons[_polysys.n_polygons-1] );
}
