#include <GTXWireframeSystem.hpp>
#include <GTXClientP.h>
#include <GTXClient.hpp>
#include <GTXError.hpp>
/*!
******************************************************************************
\brief Empty Constructor
*****************************************************************************/
GTXWireframeSystem::GTXWireframeSystem()
{
  _wiresys.n_wireframes = 0;
  _wiresys.wireframes = (GTXWireframe_C*)0;
}

/*!
******************************************************************************
\brief Copy Constructor
*****************************************************************************/
GTXWireframeSystem::GTXWireframeSystem(const GTXWireframeSystem &wiresys)
{
  GTXClientWireframeSystemDuplicate(&wiresys._wiresys, &_wiresys);
}

/*!
******************************************************************************
\brief Operator equals
*****************************************************************************/
GTXWireframeSystem GTXWireframeSystem::operator=(const GTXWireframeSystem &wiresys)
{
  GTXClientFreeWireframes(&_wiresys);
  GTXClientWireframeSystemDuplicate(&wiresys._wiresys, &_wiresys);
  return *this;
}

/*!
******************************************************************************
\brief Destructor
*****************************************************************************/
GTXWireframeSystem::~GTXWireframeSystem()
{
  GTXClientFreeWireframes(&_wiresys);
}

/*!
******************************************************************************
\brief Get the number of Wireframes Number of a Wireframe System

This function reads the number of Wireframes Number from a Wireframe System
\return Return Wireframes Number
*****************************************************************************/
int GTXWireframeSystem::GetWireframesNumber()const 
{
  return _wiresys.n_wireframes;
}
/*!
******************************************************************************
\brief Return one wireframe of a Wireframe System

This function reads the n'th wireframe of a Wireframe System
\return Return Wireframes
\param rank Rank of the wireframe (between 0 and n_wireframes-1)
\throw GTXError
*****************************************************************************/
GTXWireframe GTXWireframeSystem::GetWireframe(int rank)const 
{
  if (rank < 0 || (rank > _wiresys.n_wireframes-1))
    throw GTXError("GTXWireframeSystem::GetWireframe:Rank should be between 0 and Wireframe Number-1");
  GTXWireframe tmp;
  GTXClientWireframeDuplicate(&_wiresys.wireframes[rank], &tmp._wireframe);
  return tmp;
}

/*!
******************************************************************************
\brief add a Wireframe to a Wireframe System

This function adds a Wireframe to a Wireframe System
\param wire Wireframe
*****************************************************************************/
void GTXWireframeSystem::AddWireframe(const GTXWireframe &wire)
{
  _wiresys.n_wireframes++;
  _wiresys.wireframes =
    (GTXWireframe_C *)realloc(_wiresys.wireframes,_wiresys.n_wireframes * sizeof(GTXWireframe_C));
  GTXClientWireframeDuplicate(&wire._wireframe,&_wiresys.wireframes[_wiresys.n_wireframes-1]);
}
