/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_get_macro_indices.c 11482 2008-01-04 20:37:41Z foucher $";

#include <string.h> /* strcpy() on solaris */

/*!
******************************************************************************
\brief Add the list of available indices for the current macro variable

This function add, from the GTXserver, the list of available
indices for the current macro variable.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param nb_indice Number of indices for the current macro variable
\param indices Array of available indices for the current macro variable (or NULL)
\param alpha_indices Array of available alpha indices for the current macro variable (or NULL)

*****************************************************************************/
static GTXErrorCode st_add_macro_indices(const int nb_indice, const int *indices, const char * const *alpha_indices)
{
  GTXErrorCode error;
  char answer[10];
  int indicesflag = 0;
  int alpha_flag = 0;

  if (!_gtx_is_supported("CMACROADD", 1))
  {
    error = GTX_ERROR_SERVER;
    goto label_end;
  }

  error = GTX_ERROR_PARAMETER;

  if (indices != NULL)
    indicesflag = 1;
  if (alpha_indices != NULL)
    alpha_flag = 1;

  error = GTX_ERROR_NETWORK;
  if ( _gtx_start_packet("CMACROADD") ) goto label_end;

  error = GTX_ERROR_NETWORK;
  if (!_gtx_write_int(_gtx_server_socket, &nb_indice)) goto label_end;

  if (!_gtx_write_int(_gtx_server_socket, &indicesflag)) goto label_end;
  if (indicesflag)
    if (!_gtx_rw_vector(_gtx_server_socket, (char*)indices, nb_indice,
                        sizeof(int), (_gtx_proc_rw_t)_gtx_write_int))
      goto label_end;

  if (!_gtx_write_int(_gtx_server_socket, &alpha_flag)) goto label_end;
  if (alpha_flag)
    if (!_gtx_rw_vector(_gtx_server_socket, (char*)alpha_indices, nb_indice,
                        sizeof(char*), (_gtx_proc_rw_t)_gtx_write_string))
      goto label_end;

  if ( _gtx_send_and_wait(answer) ) goto label_end;
  error = GTX_ERROR_SERVER;
  if ( _gtx_check_answer(answer, "SDONE") ) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  if ( error )
  {
    _gtx_cleanup_socket();
  }
    
  return (error);
}


/*!
******************************************************************************
\brief Add a list of indices for the current macro variable

This function add, from the GTXserver, the list of available
indices for the current macro variable.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param nb_indice Number of indices
\param indices Array of numerical indices

*****************************************************************************/
int GTXClientAddMacroIndices(const int nb_indice, const int* indices)
{
  GTXErrorCode error;

  GTX_TRACE_FUNC_START("GTXClientAddMacroIndices",1);
  GTX_TRACE(1, ("(%d,%p)", nb_indice, indices));

  if ((nb_indice<0) ||
      (indices ==NULL))
  {
    _gtx_error("Bad parameter for GTXClientAddMacroIndices");
    error = GTX_ERROR_PARAMETER;
    goto label_end;
  }
  error = st_add_macro_indices(nb_indice, indices,NULL);
label_end:
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
/*!
******************************************************************************
\brief Add a list of indices for the current macro variable

This function add, from the GTXserver, the list of available
indices for the current macro variable.
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param nb_indice Number of indices
\param indices Array of numerical indices
\param alpha_indices Array of alpha indices

*****************************************************************************/
int GTXClientAddMacroIndicesWithAlpha(const int nb_indice, const int* indices, const char * const*alpha_indices)
{
  GTXErrorCode error;

  GTX_TRACE_FUNC_START("GTXClientAddMacroIndicesWithAlpha",1);
  GTX_TRACE(1, ("(%d,%p,%p)", nb_indice, indices, alpha_indices));
  if ((nb_indice<0) ||
      (indices ==NULL) ||
      (alpha_indices ==NULL))
  {
    _gtx_error("Bad parameter for GTXClientAddMacroIndicesWithAlpha");
    error = GTX_ERROR_PARAMETER;
    goto label_end;
  }
  error = st_add_macro_indices(nb_indice, indices, alpha_indices);
label_end:
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
