/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>
#include <limits.h>             /* UINT_MAX */

static char svnid[] _GTX_UNUSED = "$Id: api_comment.c 12024 2008-03-19 10:45:43Z foucher $";

/****************************************************************************
**
** FUNCTION: st_get_comment
**
** PURPOSE:  get file/var comment
**
** RETURNS:  GTXserver error
**
** IN_ARGS:  mode: 2 for file, 3 for var
**
** OUT_ARGS: comment: new pointer
**
*****************************************************************************/
GTXErrorCode st_get_comment(int mode,
                            char **comment)
{
  GTXErrorCode error;
  char answer[10];

  error = GTX_ERROR_NETWORK;

  /* Silently ignore old versions */
  if (!_gtx_is_supported("CCOMGET", 0))
  {
    error = GTX_ERROR_NONE;
    *comment = strdup("");
    goto label_end;
  }
  if (_gtx_start_packet("CCOMGET")) goto label_end;
  if (!_gtx_write_int(_gtx_server_socket, &mode)) goto label_end;

  if (_gtx_send_and_wait(answer)) goto label_end;

  error = GTX_ERROR_SERVER;
  if (_gtx_check_answer(answer, "SCOMMENT")) goto label_end;

  if (!_gtx_read_string(_gtx_server_socket, comment, UINT_MAX)) goto label_end;
  error = GTX_ERROR_NONE;

label_end:
  return error;
}

/****************************************************************************
**
** FUNCTION: st_set_comment
**
** PURPOSE:  set file/var comment
**
** RETURNS:  GTXserver error
**
** IN_ARGS:  mode  : 2 for file, 3 for var
** IN_ARGS:  append: 0 to set, 1 to append
** IN_ARGS:  comment: new comment or string to append
**
*****************************************************************************/
GTXErrorCode st_set_comment(int mode,
                            int append,
                            const char *comment)
{
  GTXErrorCode error;
  char answer[10];

  error = GTX_ERROR_NETWORK;

  /* Silently ignore old versions */
  if (!_gtx_is_supported("CCOMSET", 0))
  {
    if (mode == 2)
    {
      error = GTX_ERROR_NONE;
      goto label_end;
    }
    if (_gtx_start_packet("CVARCOMM")) goto label_end;
  }
  else
  {
    if (_gtx_start_packet("CCOMSET")) goto label_end;
    if (!_gtx_write_int(_gtx_server_socket, &mode)) goto label_end;
  }

  if (!_gtx_write_int(_gtx_server_socket, &append) ||
      !_gtx_write_string(_gtx_server_socket, &comment, UINT_MAX)) goto label_end;

  if (_gtx_send_and_wait(answer)) goto label_end;

  error = GTX_ERROR_SERVER;
  if (_gtx_check_answer(answer, "SDONE")) goto label_end;

  error = GTX_ERROR_NONE;

label_end:
  return error;
}

/*!
******************************************************************************
\brief Get the comment of the current file

Get the comment/description to the current file
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\retval comment returned comment

\par Remarks:
Warning: errors converning a non compatible server are silently ignored.

comment must be freed using
\code
comment = GTXClientFreePointer(comment)
\endcode
*****************************************************************************/
int GTXClientGetFileComment(char **comment)
{
  GTXErrorCode error;

  GTX_TRACE_FUNC_START("GTXClientGetFileComment",1);
  GTX_TRACE(1, ("(%p)",comment));
  
  *comment = NULL;
  error = st_get_comment(2, comment);

  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  return _gtx_client_last_error != GTX_ERROR_NONE;
}

/*!
******************************************************************************
\brief Set a comment for the current file

Set or append a comment/description to the current file
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param append
  \arg 0 to set a comment
  \arg 1 to append to an existing one
\param comment Comment to be set or append to the existing one

\par Remarks:
Warning: errors converning a non compatible server are silently ignored.
*****************************************************************************/
int GTXClientSetFileComment(int append, const char *comment)
{
  GTXErrorCode error;

  GTX_TRACE_FUNC_START("GTXClientSetFileComment",1);
  GTX_TRACE(1, ("(%d,%s)",append,comment));
  
  error = st_set_comment(2, append, comment);

  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  return _gtx_client_last_error != GTX_ERROR_NONE;
}

/*!
******************************************************************************
\brief Get the comment of the current variable

Get the comment/description to the current variable
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\retval comment returned comment

\par Remarks:
Warning: errors converning a non compatible server are silently ignored.

comment must be freed using
\code
comment = GTXClientFreePointer(comment)
\endcode
*****************************************************************************/
int GTXClientGetVariableComment(char **comment)
{
  GTXErrorCode error;

  GTX_TRACE_FUNC_START("GTXClientGetVariableComment",1);
  GTX_TRACE(1, ("(%p)",comment));
  
  *comment = NULL;
  error = st_get_comment(3, comment);

  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  return _gtx_client_last_error != GTX_ERROR_NONE;
}

/*!
******************************************************************************
\brief Set a comment for the current variable

Set or append a comment/description to the current variable
\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)
\param append
  \arg 0 to set a comment
  \arg 1 to append to an existing one
\param comment Comment to be set or append to the existing one

\par Remarks:
Warning: errors converning a non compatible server are silently ignored.
*****************************************************************************/
int GTXClientSetVariableComment(int append, const char *comment)
{
  GTXErrorCode error;

  GTX_TRACE_FUNC_START("GTXClientSetVariableComment",1);
  GTX_TRACE(1, ("(%d,%s)",append,comment));
  
  error = st_set_comment(2, append, comment);

  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  return _gtx_client_last_error != GTX_ERROR_NONE;
}
