/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_debug.c 11482 2008-01-04 20:37:41Z foucher $";

extern int _gtx_client_dbg_mode;

GTXErrorCode _gtx_client_last_error = GTX_ERROR_NONE;

/*!
******************************************************************************
\brief Set debug mode on / off
\param mode
  \arg 1 will set debug mode to on, and
  \arg 0 will set debug mode
to off
\par Remarks:
The default value is off
*****************************************************************************/
void GTXClientDebug(int mode)
{
  GTX_TRACE_FUNC_START("GTXClientDebug",1);
  GTX_TRACE(1, ("(%d)", mode));
  if (mode) _gtx_client_dbg_mode = mode;
  _gtx_debug("Setting debug mode to %s.", mode ? "on" : "off");
  if (!mode) _gtx_client_dbg_mode = mode;
  GTX_TRACE_FUNC_END(NULL,NULL);
}

/*!
******************************************************************************
\brief Get the last error that occured in GTXClient API
\return the last error that occured \see GTXErrorCode
\remark each GTXClient API function return an error code to indicate if it
was successful or not and sets this last error code to the correct value.
*****************************************************************************/
GTXErrorCode GTXClientGetLastError()
{
  return _gtx_client_last_error;
}
