/*****************************************************************************
 
            Copyright (c)2007 Geovariances, Avon, France.
 
    In consideration  of payment of  the license fee,  which is a part of
    the price you  paid for this  product, Geovariances (GV) as licensor,
    grants you, the licensee, a non-exclusive right to use this copy of a
    GV software product.
    GV reserves all rights not  expressly granted to licensee. GV retains
    titleship and ownership  of software.  This license is not  a sale of
    the original  software or any  copy. GV also  retains  titleship  and
    ownership of any modifications or  derivations of this software.  Any
    modifications of this software  must be clearly marked as such.  This
    copyright message must  appear in its entirety  in this software,  or
    any modifications or derivations thereof.
 
    Geovariances welcomes any comments, suggestions, bug reports, etc. At
    the discretion  of Geovariances,  any customer  supplied  bug  fixes,
    enhancements, or utility codes will be distributed in future software
    releases (the contributor will of course be credited).
 
            Geovariances
            49bis, Avenue Franklin Roosevelt
            77210 Avon, FRANCE
 
             Phone: +33-(0)-160.749.100
               Fax: +33-(0)-164.228.728
            e-mail: support@geovariances.fr
 
                        All Rights Reserved
 
*****************************************************************************/

#include <GTXClientP.h>

static char svnid[] _GTX_UNUSED = "$Id: api_disconnect.c 18576 2011-05-16 09:33:31Z meric $";

#include <string.h> /* strcpy() on solaris */
#include <stdlib.h> /* exit() on solaris */
#if !defined(winnt)
#include <unistd.h> /* sleep() on solaris */
#endif

/*!
******************************************************************************
\brief Close the current session with the GTXserver.

This function closes the current session with the GTXserver.
The server will exit if in mono session mode, if in  multi-session  mode, it
will only close the current connection.

\return error code:
  \arg 0 if Ok
  \arg 1 on error (see \ref GTXClientGetLastError)

\par Remarks:
If there is no opened session the function will return 0.

\sa GTXClientConnect
*****************************************************************************/
int GTXClientDisconnect(void)
{
  GTXErrorCode error;
  char answer[10];

  GTX_TRACE_FUNC_START("GTXClientDisconnect",0);
  if (_gtx_server_socket == _GTX_SOCKET_ERROR)
  {
    error = GTX_ERROR_NONE;
    goto label_end;
  }

  error = GTX_ERROR_NETWORK;
  if (_gtx_start_packet("CBYE BYE")) goto label_end;

  if (_gtx_send_and_wait(answer)) goto label_end;

  error = GTX_ERROR_SERVER;
  if (_gtx_check_answer(answer, "SBYE BYE")) goto label_end;

  _gtx_close_client();

  error = GTX_ERROR_NONE;

label_end:
  if (error) _gtx_cleanup_socket();
  GTX_TRACE_FUNC_END("%d",error);
  _gtx_client_last_error = error;
  return (error != GTX_ERROR_NONE);
}
